% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsCovarCum.R
\name{pointsCovarCum}
\alias{pointsCovarCum}
\title{R function to plot the cumulative distribution (and acceptance interval) of the values of a
spatial covariate measured at the locations of a point pattern}
\usage{
pointsCovarCum(feature, cov.var, studyplot = NULL, B = 200,
  cov.var.name = NULL, oneplot = TRUE)
}
\arguments{
\item{feature}{Feature (of point type; 'SpatialPointsDataFrame' class) representing the spatial
point pattern of interest.}

\item{cov.var}{Numeric covariate (of 'RasterLayer' class).}

\item{studyplot}{Feature (of polygon type; 'SpatialPolygonsDataFrame' class) representing the
study area and exactly matching the extent of the covariate layer. If NULL, it is worked out
from the covariate layer (may make the whole function take a while to complete).}

\item{B}{Number of randomized iterations to be used to calculate the acceptance interval (200 by
default).}

\item{cov.var.name}{Name of the input covariate to be used in the cumulative distribution chart
as label for the x axis (NULL by default).}

\item{oneplot}{Set to TRUE (default), will plot the charts into a single visualization.}
}
\value{
The function returns a 2 plots, which can be arranged in just one visualization
setting the parameter 'oneplot' to TRUE:\cr

-a plot of the point pattern against the underlaying covariate;\cr

-a plot of the cumulative distribution of the values of the covariate at the locations of the
point patter along with the above-mentioned acceptance interval.\cr
}
\description{
The function allows to test if there is a significant dependence of the input point pattern on a
underlying spatial numeric covariate (first-order effect).\cr The function takes as input three
datasets: a point patter ('SpatialPointsDataFrame' class), a covariate layer (of 'RasterLayer'
class), and (optionally) a polygon feature ('SpatialPolygonsDataFrame' class) representing the
study area and exactly matching the extent of the covariate layer. If the latter is not provided,
it is internally worked out from the covariate raster and may make the whole function take a
while to complete.\cr
}
\details{
The function plots the cumulative distribution of the values of the covariate at the locations of
the input point pattern, and adds an acceptance interval (with significance level equal to 0.05;
sensu Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press
2016, 208) that allows to assess the statistical significance of the observec cumulative
distribution. The interval is built by calculating the cumulative distribution of B realizations
of a Complete Spatial Random process, and keeping the middle 95percent of those B distributions.
B is set by default to 200, but can be increased by the user. The number of random points drawn
during each of the B simulations is equal to the number of features of the input point
pattern.\cr

For an example of the cumulative distribution plot plus acceptance interval, \strong{see} for
instance Carrero-Pazos, M. (2018). Density, intensity and clustering patterns in the spatial
distribution of Galician megaliths (NW Iberian Peninsula). Archaeological and Anthropological
Sciences. https://doi.org/10.1007/s12520-018-0662-2, figs. 4 and 5.\cr
}
\examples{
#load the point dataset representing the location of Starbucks shops
data(Starbucks)

#load the polygon dataset representing the study area
data(Massachusetts)

#load the raster representing the population density, to be used as covariate
data(popdensity)

results <- pointsCovarCum(feature=Starbucks, cov.var=popdensity, studyplot=Massachusetts,
cov.var.name="population density")

}
\seealso{
\code{\link{pointsCovarModel}}
}
\keyword{pointsCovarCum}
