

#' Tables of integrations and critical values
#'
#' A dataset containing integration values used for fast computation and critical values for hypothesis test
#'
#'
#'#'@format A list containing tables of integrations and critical values for normal, logistic and Cauchy distributions:
#' \describe{
#'   \item{Integration.Table.Normal}{2561-by-3 table for a normal distribution}
#'   \item{Integration.Table.Logistic1}{1281-by-3 table for the logistic distribution}
#'   \item{Integration.Table.Logistic2}{1281-by-1 table for the logistic distribution}
#'   \item{Integration.Table.Cauchy}{2561-by-3 table for the Cauchy distribution}
#'   \item{Critical.Value.for.OriginalTest.Normal}{100-by-6 table of critical values of the original test for a normal distribution}
#'   \item{Critical.Value.for.ModifiedTest.Normal}{100-by-6 table of critical values of the modified test for a normal distribution}
#'   \item{Critical.Value.for.OriginalTest.Logistic}{100-by-6 table of critical values of the original test for the logistic distribution}
#'   \item{Critical.Value.for.ModifiedTest.Logistic}{100-by-6 table of critical values of the modified test for the logistic distribution}
#'   \item{Critical.Value.for.OriginalTest.Cauchy}{100-by-6 table of critical values of the original test for the Cauchy distribution}
#'   \item{Critical.Value.for.ModifiedTest.Cauchy}{100-by-6 table of critical values of the modified test for the Cauchy distribution}
#'}
#' 
#' 
#' 
#'    
#' 
#'@docType data
#'@keywords datasets 
#'@name Tables
#'@usage data(Tables)
#'@export 
#' 
#' 
NULL