% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{fast_Gp_sim_Linv}
\alias{fast_Gp_sim_Linv}
\title{Approximate GP simulation with specified Linverse}
\usage{
fast_Gp_sim_Linv(Linv, NNarray, z = NULL)
}
\arguments{
\item{Linv}{Matrix containing the entries of Linverse, usually the output from
\code{vecchia_Linv}.}

\item{NNarray}{Matrix of nearest neighbor indices, usually the output from \code{\link{find_ordered_nn}}}

\item{z}{Optional vector of standard normals. If not specified,
these are computed within the function.}
}
\value{
vector of simulated values
}
\description{
In situations where we want to do many gaussian process
simulations from the same model, we can compute Linverse
once and reuse it, rather than recomputing for each identical simulation.
This function also allows the user to input the vector of standard normals \code{z}.
}
\examples{
locs <- as.matrix( expand.grid( (1:100)/100, (1:100)/100 ) )
ord <- order_maxmin(locs)
locsord <- locs[ord,]
m <- 10
NNarray <- find_ordered_nn(locsord,m)
covparms <- c(2, 0.2, 1, 0)
Linv <- vecchia_Linv( covparms, "matern_isotropic", locsord, NNarray )
y <- fast_Gp_sim_Linv(Linv,NNarray)
y[ord] <- y
fields::image.plot( matrix(y,100,100) )
}
