/*
 * Decompiled with CFR 0.152.
 */
package RerandomizationExperimentalDesign;

import ExperimentalDesign.MultipleSearchExperimentalDesigns;
import ExperimentalDesign.Tools;
import ObjectiveFunctions.AbsSumObjective;
import ObjectiveFunctions.KernelObjective;
import ObjectiveFunctions.MahalObjective;
import ObjectiveFunctions.ObjectiveFunction;
import java.io.Serializable;
import java.util.ArrayList;

public class RerandomizationExperimentalDesign
extends MultipleSearchExperimentalDesigns {
    private Double obj_val_cutoff_to_include;

    public static void main(String[] stringArray) throws Exception {
        int n;
        RerandomizationExperimentalDesign rerandomizationExperimentalDesign = new RerandomizationExperimentalDesign();
        rerandomizationExperimentalDesign.rand_obj.setSeed(1984L);
        int n2 = 10;
        int n3 = 20;
        rerandomizationExperimentalDesign.setN(n2);
        rerandomizationExperimentalDesign.setP(n3);
        for (n = 0; n < n2; ++n) {
            double[] dArray = new double[n3];
            for (int i = 0; i < n3; ++i) {
                dArray[i] = rerandomizationExperimentalDesign.rand_obj.nextDouble();
            }
            rerandomizationExperimentalDesign.setDataRow(n, dArray);
        }
        rerandomizationExperimentalDesign.Sinv = new double[n3][n3];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n3; ++i) {
                rerandomizationExperimentalDesign.Sinv[n][i] = n == i ? 1.0 : 0.0;
            }
        }
        rerandomizationExperimentalDesign.setObjective("mahal_dist");
        rerandomizationExperimentalDesign.setMaxDesigns(1000);
        rerandomizationExperimentalDesign.setObjValCutoffToInclude(10000.0);
        rerandomizationExperimentalDesign.setNumCores(3);
        rerandomizationExperimentalDesign.setWait();
        rerandomizationExperimentalDesign.beginSearch();
        double[] dArray = rerandomizationExperimentalDesign.getObjectiveVals();
        System.out.println("obj_vals: " + Tools.StringJoin(dArray));
        for (int i = 0; i < rerandomizationExperimentalDesign.ending_indicTs.length; ++i) {
            System.out.println("indicT " + (i + 1) + ": " + Tools.StringJoin(rerandomizationExperimentalDesign.ending_indicTs[i]));
        }
    }

    @Override
    public void beginSearch() {
        super.beginSearch();
        ObjectiveFunction objectiveFunction = null;
        if (this.objective.equals("mahal_dist")) {
            objectiveFunction = new MahalObjective(this.Sinv, this.n);
        } else if (this.objective.equals("abs_sum_diff")) {
            objectiveFunction = new AbsSumObjective();
        } else if (this.objective.equals("kernel")) {
            objectiveFunction = new KernelObjective(this.Kgram);
        }
        final ObjectiveFunction objectiveFunction2 = objectiveFunction;
        this.search_thread_pool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (RerandomizationExperimentalDesign.this.num_completed.get() < RerandomizationExperimentalDesign.this.max_designs && !RerandomizationExperimentalDesign.this.search_stopped.get()) {
                    double d;
                    Serializable serializable;
                    int[] nArray = Tools.fisherYatesShuffle(Tools.newBalancedBlankDesign(RerandomizationExperimentalDesign.this.n), RerandomizationExperimentalDesign.this.rand_obj);
                    if (RerandomizationExperimentalDesign.this.objective.equals("kernel")) {
                        ((KernelObjective)objectiveFunction2).setIndicT(nArray);
                    } else {
                        int[] nArray2 = Tools.findIndicies(nArray, RerandomizationExperimentalDesign.this.n / 2, 1);
                        int[] nArray3 = Tools.findIndicies(nArray, RerandomizationExperimentalDesign.this.n / 2, 0);
                        serializable = Tools.subsetMatrix(RerandomizationExperimentalDesign.this.X, nArray2);
                        ArrayList<double[]> arrayList = Tools.subsetMatrix(RerandomizationExperimentalDesign.this.X, nArray3);
                        double[] dArray = Tools.colAvg((ArrayList<double[]>)serializable, RerandomizationExperimentalDesign.this.p);
                        double[] dArray2 = Tools.colAvg(arrayList, RerandomizationExperimentalDesign.this.p);
                        objectiveFunction2.setXTbar(dArray);
                        objectiveFunction2.setXCbar(dArray2);
                    }
                    if (!((d = objectiveFunction2.calc(false)) < RerandomizationExperimentalDesign.this.obj_val_cutoff_to_include)) continue;
                    serializable = RerandomizationExperimentalDesign.this.num_completed;
                    synchronized (serializable) {
                        if (RerandomizationExperimentalDesign.this.num_completed.get() >= RerandomizationExperimentalDesign.this.max_designs || RerandomizationExperimentalDesign.this.search_stopped.get()) {
                            break;
                        }
                        ((RerandomizationExperimentalDesign)RerandomizationExperimentalDesign.this).ending_indicTs[((RerandomizationExperimentalDesign)RerandomizationExperimentalDesign.this).num_completed.get()] = nArray;
                        ((RerandomizationExperimentalDesign)RerandomizationExperimentalDesign.this).objective_vals[((RerandomizationExperimentalDesign)RerandomizationExperimentalDesign.this).num_completed.get()] = d;
                        RerandomizationExperimentalDesign.this.num_completed.getAndIncrement();
                    }
                }
            }
        });
        this.afterBeginSearch();
    }

    public void setObjValCutoffToInclude(double d) {
        this.obj_val_cutoff_to_include = d;
    }
}

