% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{initGreedyExperimentalDesignObject}
\alias{initGreedyExperimentalDesignObject}
\title{Begin A Greedy Pair Switching Search}
\usage{
initGreedyExperimentalDesignObject(
  X = NULL,
  nT = NULL,
  max_designs = 10000,
  objective = "mahal_dist",
  indicies_pairs = NULL,
  Kgram = NULL,
  wait = FALSE,
  start = TRUE,
  max_iters = Inf,
  semigreedy = FALSE,
  diagnostics = FALSE,
  num_cores = 1,
  seed = NULL
)
}
\arguments{
\item{X}{The design matrix with $n$ rows (one for each subject) and $p$ columns 
(one for each measurement on the subject). This is the design matrix you wish 
to search for a more optimal design. This parameter must be specified unless you
choose objective type \code{"kernel"} in which case, the \code{Kgram} parameter must
be specified.}

\item{nT}{The number of treatments to assign. Default is \code{NULL} which is for forced balance allocation
i.e. nT = nC = n / 2 where n is the number of rows in X (or Kgram if X is unspecified).}

\item{max_designs}{The maximum number of designs to be returned. Default is 10,000. Make this large 
so you can search however long you wish as the search can be stopped at any time by
using the \code{\link{stopSearch}} method}

\item{objective}{The objective function to use when searching design space. This is a string
with valid values "\code{mahal_dist}" (the default), "\code{abs_sum_diff}" or "\code{kernel}".}

\item{indicies_pairs}{A matrix of size $n/2$ times 2 whose rows are indicies pairs. The values of the entire matrix 
must enumerate all indicies $1, ..., n$. The default is \code{NULL} meaning to use all possible pairs.}

\item{Kgram}{If the \code{objective = kernel}, this argument is required to be an \code{n x n} matrix whose
entries are the evaluation of the kernel function between subject i and subject j. Default is \code{NULL}.}

\item{wait}{Should the \code{R} terminal hang until all \code{max_designs} vectors are found? The 
deafult is \code{FALSE}.}

\item{start}{Should we start searching immediately (default is \code{TRUE}).}

\item{max_iters}{Should we impose a maximum number of greedy switches? The default is \code{Inf} which a flag 
for ``no limit.''}

\item{semigreedy}{Should we use a fully greedy approach or the quicker semi-greedy approach? The default is
\code{FALSE} corresponding to the fully greedy approach.}

\item{diagnostics}{Returns diagnostic information about the iterations including (a) the initial starting
vectors, (b) the switches at every iteration and (c) information about the objective function
at every iteration (default is \code{FALSE} to decrease the algorithm's run time).}

\item{num_cores}{The number of CPU cores you wish to use during the search. The default is \code{1}.}

\item{seed}{The set to set for deterministic output. This should only be set if \code{num_cores = 1} otherwise
the output will not be deterministic. Default is \code{NULL} for no seed set.}
}
\value{
An object of type \code{greedy_experimental_design_search} which can be further operated upon
}
\description{
This method creates an object of type greedy_experimental_design and will immediately initiate
a search through $1_{T}$ space for forced balance designs. For debugging, you can use set the \code{seed}
parameter and \code{num_cores = 1} to be assured of deterministic output.
}
\examples{
 \dontrun{
	library(MASS)
	data(Boston)
 #pretend the Boston data was an experiment setting 
	#first pull out the covariates
 X = Boston[, 1 : 13] 
 #begin the greedy design search
	ged = initGreedyExperimentalDesignObject(X, 
		max_designs = 1000, num_cores = 3, objective = "abs_sum_diff")
	#wait
	ged
	}
}
\author{
Adam Kapelner
}
