% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pymol_script_significant_peptide.R
\name{pymol_script_significant_peptide}
\alias{pymol_script_significant_peptide}
\title{Writes a text files with pymol scripts to list significant peptides}
\usage{
pymol_script_significant_peptide(
  df,
  path = "",
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3,
  order.pep = TRUE
)
}
\arguments{
\item{df}{output from functions output_tp}

\item{path}{location where the scripts will be saved}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{order.pep}{flag allowing to either order peptide acccording to the peptide length (default), or to position in the protein sequence.}
}
\value{
pymol script with colors assigned per peptide
}
\description{
Function write a script that can be used in pymol to color structure.
Number of colors and corresponding to them ranges can be defined by user.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
pymol_script_significant_peptide(df=a, replicates=3, path=tempdir(), pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf), order.pep=TRUE )
pymol_script_significant_peptide(df=a, path=tempdir())
}
}
