% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPAV.R
\name{GPAV}
\alias{GPAV}
\title{Generalized Pool-Adjacent Violators}
\usage{
GPAV(Y, W = NULL, adj)
}
\arguments{
\item{Y}{vector of scores relative to a single example. \code{Y} must be a numeric named vector, where names
correspond to classes' names, i.e. nodes of the graph \code{g} (root node included).}

\item{W}{vector of weight relative to a single example. If the vector \code{W} is not specified (\code{def. W=NULL}), it is assumed that
\code{W} is a unitary vector of the same length of the vector \code{Y}.}

\item{adj}{adjacency matrix of the graph which must be sparse, logical and upper triangular. Number of columns of \code{adj} must be
equal to the length of \code{Y} and \code{W}.}
}
\value{
a list of 3 elements:
\itemize{
   \item \code{YFit}: a named vector with the scores of the classes corrected according to the \code{GPAV} algorithm.
   \code{NOTE}: the classes of \code{YFit} are topologically sorted, that is are in the same order of those of \code{adj}.
   \item \code{blocks}: list of vectors, containing the partitioning of nodes (represented with an integer number) into blocks;
   \item \code{W}: vector of weights.
}
}
\description{
Implementation of \code{GPAV} (Generalized Pool-Adjacent Violators) algorithm.
(\cite{Burdakov et al., In: Di Pillo G, Roma M, editors. An O(n2) Algorithm for Isotonic Regression. Boston, MA: Springer US; 2006. 
p. 25–33. Available from: \href{https://doi.org/10.1007/0-387-30065-1_3}{https://doi.org/10.1007/0-387-30065-1_3}}
}
\details{
Given the constraints adjacency matrix of the graph, a vector of scores \eqn{\hat{y} \in R^n} and a vector of strictly positive
weights \eqn{w \in R^n}, the \code{GPAV} algorithm returns a vector \eqn{\bar{y}} which is as close as possible, in the least-squares sense,
to the response vector \eqn{\hat{y}} and whose components are partially ordered in accordance with the constraints matrix \code{adj}.
In other words, \code{GPAV} solves the following problem:
\deqn{
   \bar{y} = \left\{
   \begin{array}{l}
       \min \sum_{i \in N} (\hat{y}_i - \bar{y}_i )^2\\\\
       \forall i, \quad  j \in par(i) \Rightarrow  \bar{y}_j  \geq \bar{y}_i
   \end{array}
\right.
}
}
\examples{
data(graph);
data(scores);
Y <- S[3,];
adj <- adj.upper.tri(g);
S.GPAV <- GPAV(Y,W=NULL,adj);
}
\seealso{
\code{\link{adj.upper.tri}}
}
