% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.utility.R
\name{transitive.closure.annotations}
\alias{transitive.closure.annotations}
\title{Transitive closure of annotations}
\usage{
transitive.closure.annotations(ann.spec, anc)
}
\arguments{
\item{ann.spec}{the annotation matrix of the most specific annotations (0/1): rows are genes and columns are OBO terms.}

\item{anc}{list of the ancestors of the ontology.}
}
\value{
an annotation table T: rows correspond to genes and columns to OBO terms. \eqn{T[i,j]=1} means that gene \eqn{i} is annotated for the term \eqn{j},
\eqn{T[i,j]=0} means that gene \eqn{i} is not annotated for the term \eqn{j}.
}
\description{
Performs the transitive closure of the annotations using ancestors and the most specific annotation table.
The annotations are propagated from bottom to top, enriching the most specific annotations table.
The rows of the matrix correspond to the genes of the most specific annotation table and the columns to the OBO terms/classes.
}
\examples{
data(graph);
data(labels);
anc <- build.ancestors(g);
tca <- transitive.closure.annotations(L, anc);
}
\seealso{
\code{\link{specific.annotation.matrix}}, \code{\link{build.ancestors}}
}
