% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{read.undirected.graph}
\alias{read.undirected.graph}
\title{Read an undirected graph from a file}
\usage{
read.undirected.graph(file = "graph.txt.gz")
}
\arguments{
\item{file}{name of the file to be read. The extension of the file can be plain (".txt") or compressed (".gz").}
}
\value{
A graph of class \code{graphNEL}.
}
\description{
Read a graph from a file and build a \code{graphNEL} object. The format of the input file is a sequence of rows.
Each row corresponds to an edge represented through a pair of vertexes (blank separated) and the weight of the edge.
}
\examples{
edges <- system.file("extdata/edges.txt.gz", package="HEMDAG");
g <- read.undirected.graph(file=edges);
}
