\name{leverage.default}
\alias{leverage}
\alias{leverage.default}
\alias{leverage.mer}
\title{Leverage for HLMs}
\usage{
  \method{leverage}{default} (object, ...)

  \method{leverage}{mer} (object, level, ...)
}
\arguments{
  \item{object}{fitted object of class \code{mer}}

  \item{level}{the level at which the leverage should be
  calculated: either 1 for observation level leverage or
  the name of the grouping factor (as defined in
  \code{flist} of the \code{mer} object) for group level
  leverage. \code{leverage} assumes that the grouping
  factors are unique; thus, if IDs are repeated within each
  unit, unique IDs must be generated by the user prior to
  use of \code{leverage}.}

  \item{...}{do not use}
}
\value{
  \code{leverage} returns a data frame with the following
  columns: \describe{ \item{\code{overall}}{The overall
  leverage, i.e. \eqn{H = H_1 + H_2}.}
  \item{\code{fixef}}{The leverage corresponding to the
  fixed effects.} \item{\code{ranef}}{The leverage
  corresponding to the random effects proposed by Demidenko
  and Stukel (2005).} \item{\code{ranef.uc}}{The
  (unconfounded) leverage corresponding to the random
  effects proposed by Nobre and Singer (2011).} }
}
\description{
  This function calculates the leverage of a hierarchical
  linear model fit by \code{lmer}.
}
\details{
  Demidenko and Stukel (2005) describe leverage for mixed
  (hierarchical) linear models as being the sum of two
  components, a leverage associated with the fixed
  (\eqn{H_1}) and a leverage associated with the random
  effects (\eqn{H_2}) where \deqn{H_1 = X (X^\prime V^{-1}
  X)^{-1} X^\prime V^{-1}} and \deqn{H_2 = ZDZ^{\prime}
  V^{-1} (I - H_1)} Nobre and Singer (2011) propose using
  \deqn{H_2^* = ZDZ^{\prime}} as the random effects
  leverage as it does not rely on the fixed effects.

  For individual observations \code{leverage} uses the
  diagonal elements of the above matrices as the measure of
  leverage. For higher-level units, \code{leverage} uses
  the mean trace of the above matrices associated with each
  higher-level unit.
}
\examples{
data(sleepstudy, package = 'lme4')
fm <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# Observation level leverage
lev1 <- leverage(fm, level = 1)
head(lev1)

# Group level leverage
lev2 <- leverage(fm, level = "Subject")
head(lev2)
}
\author{
  Adam Loy \email{aloy@iastate.edu}
}
\references{
  Demidenko, E., & Stukel, T. A. (2005) Influence analysis
  for linear mixed-effects models.  \emph{Statistics in
  Medicine}, \bold{24}(6), 893--909.

  Nobre, J. S., & Singer, J. M. (2011) Leverage analysis
  for linear mixed models.  \emph{Journal of Applied
  Statistics}, \bold{38}(5), 1063--1072.
}
\seealso{
  \code{\link{cooks.distance.mer}},
  \code{\link{mdffits.mer}}, \code{\link{covratio.mer}},
  \code{\link{covtrace.mer}}, \code{\link{rvc.mer}}
}
\keyword{models}
\keyword{regression}

