% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstMixtureCop.R
\name{EstMixtureCop}
\alias{EstMixtureCop}
\title{Estimation of bivariate mixture bivariate copula model}
\usage{
EstMixtureCop(y, reg, family, max_iter, eps)
}
\arguments{
\item{y}{(nx2) data matrix (observations or residuals) that will be transformed to pseudo-observations}

\item{reg}{number of regimes}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{max_iter}{maximum number of iterations of the EM algorithm}

\item{eps}{precision (stopping criteria); suggestion 0.0001.}
}
\value{
\item{theta}{(1 x reg) estimated parameter of the copula according to CRAN copula package (except for Frank copula, where theta = log(theta_R_Package)) for each component (except for degrees of freedom)}

\item{dof}{estimated degree of freedom, only for the Student copula}

\item{Q}{(1 x reg) estimated weights vector}

\item{eta}{(n x reg) conditional probabilities of being in regime k at time t given observations up to time t}

\item{tau}{estimated Kendall tau for each regime}

\item{U}{(n x 2) matrix of Rosenblatt transforms}

\item{cvm}{Cramer-von-Mises statistic for goodness-of-fit}
}
\description{
This function estimates parameters from a mixture bivariate copula model
}
