% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCtr.r
\name{getCtr}
\alias{getCtr}
\title{Get specified contour coordinates}
\usage{
getCtr(distr, tr, g, threshold = 50, makePlot = FALSE)
}
\arguments{
\item{distr}{is output array from \code{hmm.smoother}}

\item{tr}{is output dataframe from \code{calc.track}}

\item{g}{grid from \code{\link{setup.grid}}}

\item{threshold}{numeric indicating the percent contour of interest. Default 
is 50 percent.}

\item{makePlot}{is logical indicating whether or not to plot at each iteration}
}
\value{
a list of length T, dim(distr)[2], containing 1) coordinates of the 
  contour at each time, t. 2) the x and y distance to that contour from the 
  mean of the distribution (lat/lon in track). 3) reference coordinate from
  mean of distribution. 4) the points of intersection of the contour by which
  distance is measured in x and y
}
\description{
\code{getCtr} uses \code{hmm.smoother} output to calculate coordinates at a 
specified contour of each posterior distribution of the state
}
