% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm_test}
\alias{hrm_test}
\title{Test for main effects and interaction effects.}
\usage{
hrm_test(formula, data, alpha = 0.05, subject)
}
\arguments{
\item{formula}{A model formula object. The left hand side contains the response variable and the right hand side contains the whole- and subplot factors.}

\item{data}{A data.frame containing the data. The columns containing the factor variables need to have the type 'factor'. One column is needed to indentify the subjects.}

\item{alpha}{alpha level used for the test}

\item{subject}{column name within the data frame X identifying the subjects}
}
\value{
Returns an object from class HRM containing
\item{result}{A dataframe with the results from the hypotheses tests.}
\item{formula}{The formula object which was used.}
\item{alpha}{The type-I error rate which was used.}
\item{subject}{The column name identifying the subjects.}
\item{factors}{A list containing the whole- and subplot factors.}
}
\description{
Test for main effects and interaction effects of one or two between-subject factors and one, two or three within-subject factors (at most four factors can be used).
}
\examples{
data(EEG)

hrm_test(value ~ group*region+variable+variable:region-group,
           data = EEG, alpha=0.05, subject="subject")

}
\keyword{export}
