/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.util.StringUtilities;

public class StreamExec {
    private List _commands = null;
    private Process _process;

    public void cancel() {
        this._process.destroy();
    }

    public void clear() {
        this.updateStatusBar("");
        this._updateProgressBar(0);
    }

    public Process getProcess() {
        return this._process;
    }

    public static void main(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("date");
        linkedList.add("sleep 5");
        linkedList.add("date");
        linkedList.add("javac");
        StreamExec streamExec = new StreamExec();
        streamExec.setCommands(linkedList);
        streamExec.start();
    }

    public void setCommands(List list) {
        this._commands = list;
    }

    public void start() {
        String string = this._executeCommands();
        this.updateStatusBar(string);
        this.stdout(string);
    }

    public void stderr(String string) {
        System.err.println(string);
        System.err.flush();
    }

    public void stdout(String string) {
        System.out.println(string);
        System.out.flush();
    }

    public void updateStatusBar(String string) {
    }

    protected void _setProgressBarMaximum(int n) {
    }

    private void _updateProgressBar(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String _executeCommands() {
        try {
            Runtime runtime = Runtime.getRuntime();
            try {
                if (this._process != null) {
                    this._process.destroy();
                }
                this._setProgressBarMaximum(this._commands.size());
                int n = 0;
                Iterator iterator = this._commands.iterator();
                while (iterator.hasNext()) {
                    this._updateProgressBar(++n);
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    String[] stringArray = StringUtilities.tokenizeForExec((String)iterator.next());
                    this.stdout("About to execute:\n");
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.stdout("        " + stringArray[i]);
                        if (stringBuffer.length() >= 50) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(stringArray[i]);
                    }
                    if (stringBuffer.length() >= 50) {
                        stringBuffer.append(" . . .");
                    }
                    this.updateStatusBar("Executing: " + stringBuffer.toString());
                    this._process = runtime.exec(stringArray);
                    _StreamReaderThread _StreamReaderThread2 = new _StreamReaderThread(this._process.getErrorStream(), "ERROR", this);
                    _StreamReaderThread _StreamReaderThread3 = new _StreamReaderThread(this._process.getInputStream(), "OUTPUT", this);
                    _StreamReaderThread2.start();
                    _StreamReaderThread3.start();
                    try {
                        int n2 = this._process.waitFor();
                        StreamExec streamExec = this;
                        synchronized (streamExec) {
                            this._process = null;
                        }
                        if (n2 == 0) continue;
                        return "All Done";
                    }
                    catch (InterruptedException interruptedException) {
                        this.stderr("InterruptedException: " + interruptedException);
                        throw interruptedException;
                        return "All Done";
                    }
                }
            }
            catch (IOException iOException) {
                this.stderr("IOException: " + iOException);
            }
            return "All Done";
        }
        catch (InterruptedException interruptedException) {
            this._process.destroy();
            this._updateProgressBar(0);
            return "Interrupted";
        }
    }

    private class _StreamReaderThread
    extends Thread {
        private InputStream _inputStream;
        private String _streamType;
        private StreamExec _streamExec;

        _StreamReaderThread(InputStream inputStream, String string, StreamExec streamExec2) {
            this._inputStream = inputStream;
            this._streamType = string;
            this._streamExec = streamExec2;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this._streamExec.stdout(string);
                }
            }
            catch (IOException iOException) {
                this._streamExec.stderr("IOException: " + iOException);
            }
        }
    }
}

