/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.GraphicalMessageHandler;
import ptolemy.gui.MessageHandler;
import ptolemy.gui.Query;
import ptolemy.gui.StatusBar;
import ptolemy.util.StringUtilities;

public abstract class Top
extends JFrame {
    protected static File _directory = null;
    protected FileFilter _fileFilter = null;
    protected JMenu _fileMenu = new JMenu("File");
    protected JMenuItem[] _fileMenuItems = new JMenuItem[]{new JMenuItem("Open File", 79), new JMenuItem("Open URL", 85), new JMenu("New"), new JMenuItem("Save", 83), new JMenuItem("SaveAs", 65), new JMenuItem("Print", 80), new JMenuItem("Close", 67), new JMenuItem("Exit", 88)};
    protected JMenu _helpMenu = new JMenu("Help");
    protected JMenuItem[] _helpMenuItems = new JMenuItem[]{new JMenuItem("About", 65), new JMenuItem("Help", 72)};
    protected JMenuBar _menubar = new JMenuBar();
    protected StatusBar _statusBar = null;
    private static boolean _actionsDeferred = false;
    private static List _deferredActions = new LinkedList();
    private File _file = null;
    private String _lastURL = "http://ptolemy.eecs.berkeley.edu/xml/models/";
    private boolean _menuPopulated = false;
    private boolean _modified = false;
    private boolean _centering = true;

    public Top() {
        this(new StatusBar());
    }

    public Top(StatusBar statusBar) {
        this._statusBar = statusBar;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Top.this._close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        GraphicalMessageHandler.setContext(this);
    }

    public void centerOnScreen() {
        Runnable runnable = new Runnable(){

            public void run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Top.this.setLocation((toolkit.getScreenSize().width - Top.this.getSize().width) / 2, (toolkit.getScreenSize().height - Top.this.getSize().height) / 2);
                GraphicalMessageHandler.setContext(Top.this);
            }
        };
        Top.deferIfNecessary(runnable);
    }

    public final void close() {
        Runnable runnable = new Runnable(){

            public void run() {
                Top.this._close();
            }
        };
        Top.deferIfNecessary(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deferIfNecessary(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            List list = _deferredActions;
            synchronized (list) {
                _deferredActions.add(runnable);
                if (!_actionsDeferred) {
                    Runnable runnable2 = new Runnable(){

                        public void run() {
                            Top._executeDeferredActions();
                        }
                    };
                    try {
                        SwingUtilities.invokeLater(runnable2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    _actionsDeferred = true;
                }
            }
        }
    }

    public boolean getCentering() {
        return this._centering;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void report(Throwable throwable) {
        this.report("", throwable);
    }

    public void report(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setMessage(string);
                }
            }
        };
        Top.deferIfNecessary(runnable);
    }

    public void report(final String string, final Throwable throwable) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setMessage(MessageHandler.shortDescription(throwable) + ". " + string);
                }
                MessageHandler.error(string, throwable);
            }
        };
        Top.deferIfNecessary(runnable);
    }

    public void setBackground(final Color color) {
        Runnable runnable = new Runnable(){

            public void run() {
                Top.super.setBackground(color);
                if (Top.this._statusBar != null) {
                    Top.this._statusBar.setBackground(color);
                }
            }
        };
        Top.deferIfNecessary(runnable);
    }

    public void setCentering(boolean bl) {
        this._centering = bl;
    }

    public void setModified(boolean bl) {
        this._modified = bl;
    }

    public void pack() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!Top.this._menuPopulated) {
                    Top.this._menuPopulated = true;
                    Top.this._fileMenu.setMnemonic(70);
                    Top.this._helpMenu.setMnemonic(72);
                    Top.this._fileMenuItems[0].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                    Top.this._fileMenuItems[2].setMnemonic(78);
                    Top.this._fileMenuItems[2].setEnabled(false);
                    Top.this._fileMenuItems[3].setAccelerator(KeyStroke.getKeyStroke(83, 2));
                    Top.this._fileMenuItems[5].setAccelerator(KeyStroke.getKeyStroke(80, 2));
                    if (Top.this instanceof Printable || Top.this instanceof Pageable) {
                        Top.this._fileMenuItems[5].setEnabled(true);
                    } else {
                        Top.this._fileMenuItems[5].setEnabled(false);
                    }
                    Top.this._fileMenuItems[6].setAccelerator(KeyStroke.getKeyStroke(87, 2));
                    FileMenuListener fileMenuListener = new FileMenuListener();
                    for (int i = 0; i < Top.this._fileMenuItems.length; ++i) {
                        Top.this._fileMenuItems[i].setActionCommand(Top.this._fileMenuItems[i].getText());
                        Top.this._fileMenuItems[i].addActionListener(fileMenuListener);
                        Top.this._fileMenu.add(Top.this._fileMenuItems[i]);
                    }
                    Top.this._menubar.add(Top.this._fileMenu);
                    HelpMenuListener helpMenuListener = new HelpMenuListener();
                    for (int i = 0; i < Top.this._helpMenuItems.length; ++i) {
                        Top.this._helpMenuItems[i].setActionCommand(Top.this._helpMenuItems[i].getText());
                        Top.this._helpMenuItems[i].addActionListener(helpMenuListener);
                        Top.this._helpMenu.add(Top.this._helpMenuItems[i]);
                    }
                    Top.this._addMenus();
                    Top.this._menubar.add(Top.this._helpMenu);
                    Top.this.setJMenuBar(Top.this._menubar);
                    if (Top.this._statusBar != null) {
                        Top.this.getContentPane().add((Component)Top.this._statusBar, "South");
                    }
                }
                Top.super.pack();
                if (Top.this._centering) {
                    Top.this.centerOnScreen();
                }
            }
        };
        Top.deferIfNecessary(runnable);
    }

    public void show() {
        Runnable runnable = new Runnable(){

            public void run() {
                Top.this.setState(0);
                Top.super.show();
            }
        };
        Top.deferIfNecessary(runnable);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "Ptolemy II " + this.getClass().getName() + "\n" + "By: Claudius Ptolemaeus, ptolemy@eecs.berkeley.edu\n" + "For more information, see\n" + "http://ptolemy.eecs.berkeley.edu/ptolemyII\n\n" + "Copyright (c) 1997-2003, " + "The Regents of the University of California.", "About Ptolemy II", 1);
    }

    protected void _addMenus() {
    }

    protected boolean _clear() {
        return this._queryForSave();
    }

    protected boolean _close() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                this.dispose();
                return true;
            }
            return false;
        }
        this.dispose();
        return true;
    }

    protected void _exit() {
        if (this.isModified()) {
            if (this._queryForSave()) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    protected String _getName() {
        if (this._file == null) {
            return "Unnamed";
        }
        return this._file.getName();
    }

    protected void _help() {
        this._about();
    }

    protected void _open() {
        block10: {
            Object object;
            JFileChooser jFileChooser = new JFileChooser();
            if (this._fileFilter != null) {
                jFileChooser.addChoosableFileFilter(this._fileFilter);
            }
            jFileChooser.setDialogTitle("Select a model file.");
            if (_directory != null) {
                jFileChooser.setCurrentDirectory(_directory);
            } else {
                object = StringUtilities.getProperty("user.dir");
                if (object != null) {
                    jFileChooser.setCurrentDirectory(new File((String)object));
                }
            }
            if (jFileChooser.showOpenDialog(this) == 0) {
                _directory = jFileChooser.getCurrentDirectory();
                try {
                    object = jFileChooser.getSelectedFile().getCanonicalFile();
                    this._read(((File)object).toURL());
                }
                catch (Error error) {
                    try {
                        throw new RuntimeException(error);
                    }
                    catch (Exception exception) {
                        this.report("Error while reading input:", exception);
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage() == null || exception.getMessage().startsWith("*** Canceled.")) break block10;
                    this.report("Error reading input", exception);
                }
            }
        }
    }

    protected void _openURL() {
        Query query = new Query();
        query.setTextWidth(60);
        query.addLine("url", "URL", this._lastURL);
        ComponentDialog componentDialog = new ComponentDialog((Frame)this, "Open URL", query);
        if (componentDialog.buttonPressed().equals("OK")) {
            this._lastURL = query.getStringValue("url");
            try {
                URL uRL = new URL(this._lastURL);
                this._read(uRL);
            }
            catch (Exception exception) {
                this.report("Error reading URL:\n" + this._lastURL, exception);
            }
        }
    }

    protected void _print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this instanceof Pageable) {
            printerJob.setPageable((Pageable)((Object)this));
        } else if (this instanceof Printable) {
            PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
            printerJob.setPrintable((Printable)((Object)this), pageFormat);
        } else {
            return;
        }
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                MessageHandler.error("Printing Failed", exception);
            }
        }
    }

    protected abstract void _read(URL var1) throws Exception;

    protected boolean _save() {
        if (this._file != null) {
            try {
                this._writeFile(this._file);
                this.setModified(false);
                return true;
            }
            catch (IOException iOException) {
                this.report("Error writing file", iOException);
                return false;
            }
        }
        return this._saveAs();
    }

    protected boolean _saveAs() {
        JFileChooser jFileChooser = new JFileChooser();
        if (this._fileFilter != null) {
            jFileChooser.addChoosableFileFilter(this._fileFilter);
        }
        jFileChooser.setDialogTitle("Save as...");
        if (_directory != null) {
            jFileChooser.setCurrentDirectory(_directory);
        } else {
            String string = StringUtilities.getProperty("user.dir");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string;
            int n2;
            this._file = jFileChooser.getSelectedFile();
            if (this._file.exists() && (n2 = JOptionPane.showOptionDialog(this, string = "Overwrite " + this._file.getName() + "?", "Save Changes?", 0, 3, null, null, null)) == 1) {
                return false;
            }
            this.setTitle(StringUtilities.abbreviate(this._getName()));
            _directory = jFileChooser.getCurrentDirectory();
            return this._save();
        }
        return false;
    }

    protected abstract void _writeFile(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _executeDeferredActions() {
        List list = _deferredActions;
        synchronized (list) {
            try {
                Iterator iterator = _deferredActions.iterator();
                while (iterator.hasNext()) {
                    Runnable runnable = (Runnable)iterator.next();
                    runnable.run();
                }
            }
            finally {
                _actionsDeferred = false;
                _deferredActions.clear();
            }
        }
    }

    private boolean _queryForSave() {
        Object[] objectArray = new Object[]{"Save", "Discard changes", "Cancel"};
        String string = "Save changes to " + StringUtilities.split(this._getName()) + "?";
        int n = JOptionPane.showOptionDialog(this, string, "Save Changes?", 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            return this._save();
        }
        return n == 1;
    }

    class HelpMenuListener
    implements ActionListener {
        HelpMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("About")) {
                    Top.this._about();
                } else if (string.equals("Help")) {
                    Top.this._help();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Help Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }

    class FileMenuListener
    implements ActionListener {
        FileMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicalMessageHandler.setContext(Top.this);
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            try {
                if (string.equals("Open File")) {
                    Top.this._open();
                } else if (string.equals("Open URL")) {
                    Top.this._openURL();
                } else if (string.equals("Save")) {
                    Top.this._save();
                } else if (string.equals("SaveAs")) {
                    Top.this._saveAs();
                } else if (string.equals("Print")) {
                    Top.this._print();
                } else if (string.equals("Close")) {
                    Top.this._close();
                } else if (string.equals("Exit")) {
                    Top.this._exit();
                }
            }
            catch (Exception exception) {
                MessageHandler.error("File Menu Exception:", exception);
            }
            Top.this.repaint();
        }
    }
}

