% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BD_ordinations.R
\name{physeq_list_betaDiv}
\alias{physeq_list_betaDiv}
\title{calculating beta diversity for a list of phyloseq objects}
\usage{
physeq_list_betaDiv(physeq_l, method = "unifrac", weighted = TRUE,
  fast = TRUE, normalized = TRUE, parallel = FALSE)
}
\arguments{
\item{physeq_l}{A list of phyloseq objects}

\item{method}{See phyloseq::distance}

\item{weighted}{Weighted Unifrac (if calculating Unifrac)}

\item{fast}{Fast calculation method}

\item{normalized}{Normalized abundances}

\item{parallel}{Calculate in parallel}
}
\value{
List of dist objects
}
\description{
For each phyloseq object in a list, calculates beta-diversity
between all samples using the phyloseq::distance function.
}
\examples{
data(physeq_S2D2_l)
\dontrun{
physeq_S2D2_l_d = physeq_list_betaDiv(physeq_S2D2_l)
}

}
