% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_PlotDurationCurve.R
\name{PlotDurationCurve}
\alias{PlotDurationCurve}
\title{Plot duration curves}
\usage{
PlotDurationCurve(
  freq,
  xscale = "lin",
  yscale = "log",
  add.legend = FALSE,
  l.legend = NULL,
  ylim = NULL,
  xlab = "Flow exceedance percentile",
  ylab = "m3s",
  col = "blue",
  lty = 1,
  lwd = 1,
  mar = c(3, 3, 1, 1) + 0.1
)
}
\arguments{
\item{freq}{Data frame with at least two columns, containing probabilities in the first and series of data quantiles in the remaining columns. Typically
an object as returned by \code{\link{ExtractFreq}} or a subset thereof.}

\item{xscale}{Character string, keyword for x-axis scaling. Either \code{"lin"} for linear scaling or \code{"gauss"} for gaussian scaling as in a normal
probability plot, which allows for for better comparison of low flow and high flow frequencies.}

\item{yscale}{Character string, keyword for y-axis scaling. Either \code{"lin"} for linear scaling or \code{"log"} for common logarithm scaling.}

\item{add.legend}{Logical. If \code{TRUE}, a legend will be added to the plot, including the number of observations on which the quantiles are based for
each curve if \code{freq} is a result from \code{\link{ExtractFreq}}.}

\item{l.legend}{Character vector. If non-NULL, legend labels are read from here instead of from column names in \code{freq}.}

\item{ylim}{Numeric vector of length two, giving y-axis limits. \code{NULL} for default values.}

\item{xlab}{Character string, x-axis label.}

\item{ylab}{Character or \code{\link{plotmath}} expression string. Y-axis label, either as keyword \code{"m3s"} or \code{"mmd"} for pre-defined pretty
discharge labels, or any other string which will be plotted unchanged.}

\item{col}{Line color specification, see \code{\link{par}} for details. Defaults to blue. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{lty}{Line type specification, see \code{\link{par}} for details. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{lwd}{Line width specification, see \code{\link{par}} for details. Either a single value or a vector of the same length as quantile
series in \code{freq}.}

\item{mar}{Numeric vector of length 4, margin specification as in \code{\link{par}} with modified default. Details see there.}
}
\value{
\code{PlotDurationCurve} returns a plot to the currently active plot device.
}
\description{
Convenience wrapper function for a (multiple) line \code{\link{plot}}, with pretty defaults for axis annotation and a Gaussian scaling option for the x-axis.
}
\details{
\code{PlotDurationCurve} plots a duration curve with pretty formatting defaults. The function sets \code{\link{par}} parameters \code{tcl} and \code{mgp}
internally and will override previously set values for the returned plot. It typically uses results from \code{\link{ExtractFreq}} as input data and via that
function it can be used to visualize and compare time series properties.
}
\examples{
# Import source data
te1 <- ReadBasinOutput(filename = system.file("demo_model", "results", "0003587.txt", 
                       package = "HYPEtools"))
te2 <- ExtractFreq(te1[, c("COUT", "ROUT")])
# Plot flow duration curves for simulated and observed discharge
PlotDurationCurve(freq = te2, add.legend = TRUE, col = c("red", "blue"))

}
\seealso{
\code{\link{ExtractFreq}}
}
