% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC_threshold_matrix.R
\name{IC_threshold_matrix}
\alias{IC_threshold_matrix}
\title{Calculate correlation matrix}
\usage{

  IC_threshold_matrix(data = stop("A dataframe or an IconoCorel object is required"),
  threshold = NULL, use = c("pairwise.complete.obs", "everything",
  "all.obs", "complete.obs", "na.or.complete"), method = c("pearson",
  "kendall", "spearman"), model = c("OAT", "ATT"), progress = TRUE,
  debug = FALSE)
}
\arguments{
\item{data}{A dataframe or an IconoCorel object from a previous run of IC_threshold_matrix}

\item{threshold}{threshold for partial and full correlations}

\item{use}{an optional character string giving a method for computing covariances in the presence of missing values. This must be (an abbreviation of) one of the strings "everything", "all.obs", "complete.obs", "na.or.complete", or "pairwise.complete.obs".}

\item{method}{a character string indicating which correlation coefficient (or covariance) is to be computed. One of "pearson" (default), "kendall", or "spearman": can be abbreviated.}

\item{model}{a character string indicating if linear model uses all variables at a time (AAT) or one at a time (OAT).}

\item{progress}{show a progress bar}

\item{debug}{display information about progression of computing}
}
\value{
A list
}
\description{
This function calculates the matrix of correlations thresholded using partial correlation.\cr
If the threshold is not given, the object that is produced can be used later for thresholding.\cr
For model OAT: a correlation is retained if it is higher that the threshold and if all partial correlationw of the two variables and any third one are all lower than the threshold.\cr
For model AAT: a correlation is retained if it is higher than the threshold and the partial correlation is lower than the threshold. In this case, no missing value is accepted.\cr
The use and method parameters are used by cor() function. The function uses by default a parallel computing in Unix or MacOSX systems. 
If progress is TRUE and the package pbmcapply is present, a progress bar is displayed. If debug is TRUE, some informations are shown during the process but parallel computing is not used.\cr
\code{https://fr.wikipedia.org/wiki/Iconographie_des_corrélations}
}
\details{
IC_threshold_matrix calculates correlation matrix thresholed by partial correlation
}
\examples{
\dontrun{
library("HelpersMG")
es <- matrix(c("e1", "52", "12", "12", "5",
"e2", "59", "12.5", "9", "5",
"e3", "55", "13", "15", "9",
"e4", "58", "14.5", "5", "5",
"e5", "66", "15.5", "11", "13.5",
"e6", "62", "16", "15", "18",
"e7", "63", "17", "12", "18",
"e8", "69", "18", "9", "18"), ncol=5, byrow = TRUE)
colnames(es) <- c("Élève", "Poids", "Âge", "Assiduité", "Note")
es <- as.data.frame(es, stringsasFactor=FALSE)
es[, 2] <- as.numeric(as.character(es[, 2]))
es[, 3] <- as.numeric(as.character(es[, 3]))
es[, 4] <- as.numeric(as.character(es[, 4]))
es[, 5] <- as.numeric(as.character(es[, 5]))

es

df <- IC_clean_data(es, debug = TRUE)
cor_matrix <- IC_threshold_matrix(data=df, threshold = NULL, progress=FALSE)
cor_threshold <- IC_threshold_matrix(data=cor_matrix, threshold = 0.3)
par(mar=c(1,1,1,1))
set.seed(4)
plot(cor_threshold)
cor_threshold_Note <- IC_correlation_simplify(matrix=cor_threshold, variable="Note")
plot(cor_threshold_Note)

# Using the model All at a time

cor_threshold_AAT <- IC_threshold_matrix(data=df, threshold = 0.3, model="AAT")
par(mar=c(1,1,1,1))
set.seed(4)
plot(cor_threshold_AAT, show.legend.strength="bottomleft")



############
dta <- structure(list(Élève = structure(1:8, .Label = c("e1", "e2", 
"e3", "e4", "e5", "e6", "e7", "e8"), class = "factor"), Poids = c(52L, 
59L, 55L, 58L, 66L, 62L, 63L, 69L), Âge = c(12, 12.5, 13, 14.5, 
15.5, 16, 17, 18), Assiduité = c(12L, 9L, 15L, 5L, 11L, 15L, 
12L, 9L), Note = c(5, 5, 9, 5, 13.5, 18, 18, 18), e1 = c(1L, 
0L, 0L, 0L, 0L, 0L, 0L, 0L), e2 = c(0L, 1L, 0L, 0L, 0L, 0L, 0L, 
0L), e3 = c(0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L), e4 = c(0L, 0L, 0L, 
1L, 0L, 0L, 0L, 0L), e5 = c(0L, 0L, 0L, 0L, 1L, 0L, 0L, 0L), 
    e6 = c(0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L), e7 = c(0L, 0L, 0L, 
    0L, 0L, 0L, 1L, 0L), e8 = c(0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L
    )), .Names = c("Élève", "Poids", "Âge", "Assiduité", 
"Note", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8"), class = "data.frame", row.names = c(NA, 
-8L))

dta0 <- dta[, 2:ncol(dta)]
ic0 <- IC_threshold_matrix(data = dta0)
cor_threshold <- IC_threshold_matrix(data=ic0, threshold = 0.3)
par(mar=c(1,1,1,1))
set.seed(4)
library("igraph")

plot(cor_threshold, vertex.color="red", show.legend.strength = FALSE)
plot(IC_correlation_simplify(matrix=cor_threshold), 
     show.legend.strength = FALSE, show.legend.direction = FALSE)

}
}
\references{
Lesty, M., 1999. Une nouvelle approche dans le choix des régresseurs de la régression multiple en présence d’interactions et de colinéarités. Revue de Modulad 22, 41-77.
}
\seealso{
Other Iconography of correlations: \code{\link{IC_clean_data}},
  \code{\link{IC_correlation_simplify}},
  \code{\link{plot.IconoCorel}}
}
\author{
Marc Girondot
}
\concept{Iconography of correlations}
