% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.info.R
\name{sun.info}
\alias{sun.info}
\title{Estimate the time of sunrise and sunset according to longitude, latitude and date}
\usage{
sun.info(date, latitude, longitude)
}
\arguments{
\item{date}{A vector with the time at which sun fates are needed}

\item{latitude}{The latitude at which estimate the sun fates}

\item{longitude}{The longitude at which estimate the sun fates}
}
\value{
A data.frame with information about daily sun
}
\description{
Estimate the sun fates according to latitude and date.\cr
Can be compared with the function \code{sunrise.set()} of package \code{StreamMetabolism}.
}
\details{
sun.info estimate the time of sunrise and sunset according to longitude, latitude and date
}
\examples{
\dontrun{
# Generate a timeserie of time
date <- seq(from=as.Date("2000-01-01"), to=as.Date("2000-12-31"), by="1 day")
plot(date, sun.info(date, latitude=23, longitude=0)$day.length, bty="n", 
 las=1, type="l", xlab="Ordinal days", ylab="Day length in hours")
plot(date, sun.info(date, latitude=23, longitude=0)$sunrise, bty="n", 
 las=1, type="l", xlab="Ordinal days", ylab="Sun rise in hours")
}
}
\references{
Teets, D.A. 2003. Predicting sunrise and sunset times. The College Mathematics Journal 34(4):317-321.
}
\seealso{
Other Periodic patterns of indices: 
\code{\link{index.periodic}()},
\code{\link{minmax.periodic}()},
\code{\link{moon.info}()},
\code{\link{tide.info}()}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Periodic patterns of indices}
