% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcutter.R
\name{dcutter}
\alias{dcutter}
\title{Distribution of the fitted distribution without cut.}
\usage{
dcutter(
  par,
  observations = NULL,
  distribution = "gamma",
  n.mixture = NULL,
  debug = FALSE,
  limits.lower = NULL,
  limits.upper = NULL,
  log = TRUE
)
}
\arguments{
\item{par}{Values for parameters of distribution}

\item{observations}{The observations; see description.}

\item{distribution}{Can be gamma, normal, weibull, lognormal, or generalized.gamma.}

\item{n.mixture}{Number of distributions}

\item{debug}{If TRUE, show some information. If 2, show more information.}

\item{limits.lower}{Value for lower detection limit}

\item{limits.upper}{Value for upper detection limit}

\item{log}{If TRUE, return the log likelihood}
}
\value{
The density of the cutter function according to observations.
}
\description{
If observations must be a data.frame with 4 columns:\cr
observations: A column for the measurements;\cr
LDL: A column for the lower detection limit;\cr
UDL: A column for the upper detection limit;\cr
Cut: A column for the truncated of censored nature of the data.\cr
}
\details{
dcutter returns the density of the cutter function
}
\examples{
\dontrun{
library(HelpersMG)
par <- c('shape1' = 0.42265849507444225, 
         'scale1' = 14.139457094879594, 
         'shape2' = 1.667131542489706, 
         'scale2' = 0.10763344388223803, 
         'p1' = 0.12283307526788023)
obs <- data.frame(Observations=c(0.755, 1.013, 2.098, 6.265, 4.708, 0.078, 2.169, 0.403, 1.251, 
                                 0.008, 1.419, 1.078, 2.744, 81.534, 1.426, 13.486, 7.813, 0.165, 
                                 0.118, 0.864, 0.369, 7.159, 2.605, 1.579, 1.646, 0.484, 4.492, 
                                 0.139, 0.28, 0.154, 0.106, 0.104, 4.185, 0.735, 0.149, 0.183, 
                                 0.062, 8.246, 0.165, 0.121, 0.109, 0.092, 0.162, 0.108, 0.139, 
                                 0.141, 0.124, 0.124, 0.151, 0.141, 0.364, 0.295, 0.09, 0.135, 
                                 0.154, 0.218, 0.167, -Inf, 0.203, 0.228, 0.107, 0.162, 0.194, 
                                 0.322, 0.351, 0.17, 0.236, 0.176, 0.107, 0.12, 0.095, 0.27, 0.194, 
                                 0.125, 0.123, 0.085, 0.164, 0.106, 0.079, 0.162), 
                 LDL=0.001, UDL=NA, Cut="censored")
dcutter(par=par, observations=obs, distribution="gamma", 
        n.mixture=NULL, debug=FALSE, limits.lower=NULL, 
        limits.upper=NULL,log=FALSE)
dcutter(par=par, observations=obs, distribution="gamma", 
        n.mixture=NULL, debug=FALSE, limits.lower=NULL, 
        limits.upper=NULL, log=TRUE)
        
}
}
\seealso{
Other Distributions: 
\code{\link{cutter}()},
\code{\link{dbeta_new}()},
\code{\link{dggamma}()},
\code{\link{logLik.cutter}()},
\code{\link{plot.cutter}()},
\code{\link{print.cutter}()},
\code{\link{rcutter}()}
}
\author{
Marc Girondot
}
\concept{Distributions}
