% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{get.MatH.stats}
\alias{get.MatH.stats}
\alias{get.MatH.stats,MatH-method}
\title{Method get.MatH.stats}
\usage{
get.MatH.stats(object, ...)

\S4method{get.MatH.stats}{MatH}(object, stat = "mean", prob = 0.5)
}
\arguments{
\item{object}{a \code{MatH} object}

\item{...}{a set of other parameters}

\item{stat}{(optional) a string containing the required statistic. Default='mean'\cr
- \code{stat='mean'} - for computing the mean of each histogram\cr
- \code{stat='median'} - for computing the median of each histogram\cr
- \code{stat='min'} - for computing the minimum of each histogram\cr
- \code{stat='max'} - for computing the maximum of each histogram\cr
- \code{stat='std'} - for computing the standard deviatio of each histogram\cr
- \code{stat='skewness'} - for computing the skewness of each histogram\cr
- \code{stat='kurtosis'} - for computing the kurtosis of each histogram\cr
- \code{stat='quantile'} - for computing the quantile ot level \code{prob} of each histogram\cr}

\item{prob}{(optional)a number between 0 and 1 for computing the value once choosen the \code{'quantile'} option for \code{stat}.}
}
\value{
A list
}
\description{
Method get.MatH.stats

It returns statistics for each distribution contained in a \code{MatH} object.
}
\section{Slots}{

\describe{
\item{\code{stat}}{- the chosen statistic}

\item{\code{prob}}{- level of probability if stat='quantile'}

\item{\code{MAT}}{- a matrix of values}
}}
\examples{
get.MatH.stats(BLOOD) # the means of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='median') # the medians of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='quantile', prob=0.5) #the same as median
get.MatH.stats(BLOOD,stat='min') # minima of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='quantile', prob=0) #the same as min
get.MatH.stats(BLOOD,stat='max') # maxima of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='quantile', prob=1) #the same as max
get.MatH.stats(BLOOD,stat='std') # standard deviations of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='skewness') #skewness indices of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='kurtosis') #kurtosis indices of the distributions in BLOOD dataset
get.MatH.stats(BLOOD,stat='quantile',prob=0.05)
#the fifth percentiles of distributions in BLOOD dataset
}

