% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\name{WH.vec.mean}
\alias{WH.vec.mean}
\alias{WH.vec.mean,MatH-method}
\title{Method WH.vec.mean}
\usage{
WH.vec.mean(object, ...)

\S4method{WH.vec.mean}{MatH}(object, w = numeric(0))
}
\arguments{
\item{object}{a \code{MatH} object}

\item{...}{optional arguments}

\item{w}{it is possible to add a vector of weights (positive numbers) having the same size of
the \code{MatH object}, default = equal weights for all}
}
\value{
a \code{distributionH} object, i.e. a histogram
}
\description{
Compute a histogram that is the weighted mean of the set of histograms contained
in a \code{MatH} object, i.e. a matrix of histograms, consistent with
a set of distributions equipped with a L2 wasserstein metric.
}
\examples{
hmean <- WH.vec.mean(BLOOD)
# generate a set of random weights
RN <- runif(get.MatH.nrows(BLOOD) * get.MatH.ncols(BLOOD))
hmean <- WH.vec.mean(BLOOD, w = RN)
}
