% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkAnalysis.R
\name{get_metrics}
\alias{get_metrics}
\title{Compute network metrics}
\usage{
get_metrics(
  network,
  mode = "directed",
  weighted = TRUE,
  transfers = TRUE,
  metrics = c("degree", "closeness", "clusters", "betweenness"),
  clusters = c("cluster_fast_greedy", "cluster_infomap"),
  hubs = "all_clusters",
  options = list(degree = list(modes = c("in", "out", "total")), closeness = list(modes =
    "total"), betweenness = list(), cluster_fast_greedy = list(undirected = "collapse"),
    cluster_infomap = list(undirected = "collapse"), clusters = list(algos =
    c("cluster_fast_greedy", "cluster_infomap"), undirected = "collapse"))
)
}
\arguments{
\item{network}{the network to analyze. Must be an igraph, HospiNet or a square adjacency matrix (n*n).}

\item{mode}{either "directed" or "undirected" network measures}

\item{weighted}{TRUE if the network is weighted}

\item{transfers}{TRUE if metrics specific to subject transfers must be computed}

\item{metrics}{list of the metrics to compute}

\item{clusters}{choose between cluster algorithm: cluster_fast_greedy or cluster_infomap}

\item{hubs}{choose between getting hubs from "all_clusters" or "global"}

\item{options}{named list of options to be passed to the igraph functions}
}
\description{
Function computing different network analysis metrics.
}
