% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindPosterior.R
\name{bindSim}
\alias{bindSim}
\alias{bindPosterior}
\title{Bind Output From coda Samples}
\usage{
bindSim(hydeSim, relabel_factor = TRUE)

bindPosterior(hydeSim, relabel_factor = TRUE)
}
\arguments{
\item{hydeSim}{An object of class \code{HydeSim}}

\item{relabel_factor}{Logical.  If \code{TRUE}, factors that had been 
converted to integers for the JAGS code can be relabelled as factors 
for additional analysis in R.}
}
\description{
After determining the simulated distributions are satisfactory,
  it can be advantageous to bind the simulated distributions together in
  order to aggregate values and perform other manipulations and analyses.
}
\details{
For the purposes of this function, it is assumed that if the 
  simulated distributions are satisfactory, the multiple chains in a run 
  can be bound together.  Subsequently, the multiple runs are bound 
  together.  Lastly, the factors are relabeled, if requested.
}
\examples{
#' data(PE, package="HydeNet")
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE) 
  
                 
compiledNet <- compileJagsModel(Net, n.chains=5)

#* Generate the simulated distribution
Simulated <- HydeSim(compiledNet, 
                     variable.names = c("d.dimer", "death"), 
                     n.iter=1000)

Bound <- bindSim(Simulated)

#* Bind a Decision Network
#* Note: angio shouldn't really be a decision node.  
#*       We use it here for illustration
Net <- setDecisionNodes(Net, angio, treat)
compiledDecision <- compileDecisionModel(Net, n.chains=5)
SimulatedDecision <- HydeSim(compiledDecision, 
                             variable.names = c("d.dimer", "death"),
                             n.iter = 1000)

}
\author{
Jarrod Dalton and Benjamin Nutter
}
