% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTransp.R
\name{PrandtTD}
\alias{PrandtTD}
\title{Prandt Number, Function of Temperature and Density}
\usage{
PrandtTD(Temp, D, digits = 9)
}
\arguments{
\item{Temp}{Temperature [ K ]}

\item{D}{Density [ kg m-3 ]}

\item{digits}{Digits of results (optional)}
}
\value{
The Prandt Number: Pr [ - ]

Error message (if an error occur)
}
\description{
The function \code{PrandtTD(Temp,D,digits=9)} computes the Prandt Number, i.e., 
     the product of the dynamic viscosity by the specific isobaric heat capacity,
     divided by the thermal conductivity of water for given T [K] and D [kg/m3].
}
\details{
This function calls a Fortran DLL that computes the Prandt Number, valid from 
    the triple point to the pressure of 1000 MPa and temperature of 1173.15K.
}
\examples{
Temp <- 500.
D <- 838.025
Pran <- PrandtTD(Temp,D)
Pran

}
