% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SplitOneMutectVCF}
\alias{SplitOneMutectVCF}
\title{Split a mutect2 VCF into SBS, DBS, and ID VCFs, plus a list of other mutations}
\usage{
SplitOneMutectVCF(vcf.df, name.of.VCF = NULL)
}
\arguments{
\item{vcf.df}{An in-memory data.frame representing a Mutect VCF, including
VAFs, which are added by \code{\link{ReadMutectVCF}}.}

\item{name.of.VCF}{Name of the VCF file.}
}
\value{
A list with 3 in-memory VCFs and two left-over
VCF-like data frames with rows that were not incorporated
into the first 3 VCFs, as follows:

 * \code{SBS}: VCF with only single base substitutions.

 * \code{DBS}: VCF with only doublet base substitutions
  as called by Mutect.

 * \code{ID}: VCF with only small insertions and deletions.

 * \code{discarded.variants}: \strong{Non-NULL only if} there are variants
 that were excluded from the analysis. See the added extra column
 \code{discarded.reason} for more details.
 @md
}
\description{
Split a mutect2 VCF into SBS, DBS, and ID VCFs, plus a list of other mutations
}
\keyword{internal}
