% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_equivalence_multiple.R
\name{equivalence_multiple}
\alias{equivalence_multiple}
\title{Checking the optimality of a given design with respect to  the multi-objective criterion for the 4-parameter logisitic model.}
\usage{
equivalence_multiple(x, w, lx, ux, param, lambda, delta,
  maxeval_equivalence = 6000, plot_sensitivity = TRUE)
}
\arguments{
\item{x}{a vector of design points. When design space is multi-dimensional then \code{x} should be filled dimension by dimension. See "Examples".}

\item{w}{a vector of design weights.}

\item{lx}{lower bound of the design space \eqn{\chi}.}

\item{ux}{upper bound of the design space \eqn{\chi}.}

\item{param}{initial guess for parameters \eqn{\Theta = (\theta_1, \theta_2, \theta_3, \theta_4)}{\Theta = (\theta1, \theta2, \theta3, \theta4)}.}

\item{lambda}{user select weights, where \eqn{\lambda_1}{\lambda1} is the weight for estimating parameters,
\eqn{\lambda_2}{\lambda2} is the weignt for estimating median effective dose level (ED50), and \eqn{\lambda_3}{\lambda3} is the weight for estimating minimum effective dose level (MED).}

\item{delta}{numeric, predetermined clinically significant effect to define the MED.}

\item{maxeval_equivalence}{maximum number of evaulations (\code{maxeval})  that will be passed to optimization function \code{\link[nloptr]{directL}} to find the maximum of the sensitivity function required for calculating DLB. See "Details" of \code{\link{equivalence}}.}

\item{plot_sensitivity}{logical; sensitivity should be plotted? see "Details" of \code{\link{equivalence}}.}
}
\value{
an object of class \code{'equivalence'} that is a list contains:
 \describe{
 \item{\code{max_deriv}}{maximum of the sensitivity function}
 \item{\code{DLB}}{D-efficiency lower bound. If negative, the value of \code{maxeval_equivalence} should be increased to find the global maximum.}
 \item{\code{crtval}}{criterion value.}
 }
}
\description{
The equivalence theorem states
 that for a given vector of weights
 \eqn{\lambda = (\lambda_1, \lambda_2, \lambda_3)}{\lambda = (\lambda1, \lambda2, \lambda3)}, the design \eqn{\xi_\lambda}
 is the multi-objective optimal design if and only if for all does \eqn{x} in the dose range \eqn{\chi} (design space)
 \deqn{d(x, \xi_\lambda) \leq 0}{d(x, \xi_\lambda) <= 0}
 with equality when \eqn{x} is a dose level of design \eqn{\xi_\lambda}.
 See Eq. 6 of Hyun and Wong (2015) for the details.
}
\details{
When \eqn{\lambda_2 = 1}{\lambda1 = 1}, the function checks the equivalence theorem with respect to the
 c-optimality criterion for estimating ED50. When \eqn{\lambda_3 = 1}{\lambda3 = 1}, it checks the equivalence theorem
 with respect to the c-optimality criterion for estimating MED.  In both cases,
  due to the tolerance issue for computing the generalized inverse, the results may not be true.
  Therefore, this function should only be used for multiple-objective optimal design
  \eqn{\lambda_1 \neq 0} and  \eqn{\lambda_2 \neq 0.}{\lambda1 and \lambda2 are not equal to 0.}

 The tolerance for finding the general inverse is set to \code{.Machine$double.xmin}.
}
\examples{
## verfying the design in Table 2 of Hyun and Wong (2015), first row, fisrt column.
Theta1 <- c(1.563, 1.790, 8.442, 0.137)
equivalence_multiple (x = c(log(.001), -5.21, -4.08, log(1000)),
                     w = c(.25, .25, .25, .25),
                     lx = log(.001), ux = log(1000),
                     param = Theta1,
                     lambda = c(1, 0, 0),
                     delta = -1)

\dontshow{
\dontrun{
#########################################################################################
## examples fof using this function for c-optimal designs
# first row second column: c-optimal design for estimating ED50
equivalence_multiple (x = c(log(.001), -4.80, log(1000)),
                     w = c(.276, .500, .224),
                     lx = log(.001), ux = log(1000),
                     param = Theta1,
                     lambda = c(0, 1, 0),
                     delta = -1)
## criterion value is 1e+24 which will be returned when variance for estimating ED50 is comutationaly negative!
## if we change the tolerance for finding  Moore-Penrose Matrix Inverse to .Machine$double.eps
# when get 2.201179 for the criterion value

equivalence_multiple (x = c(-6.910, -4.6150000, -4.6000000, 6.910),
                     w =   c(0.499998, 0.2230491, 0.2305728, 0.04637965),
                     lx = log(.001), ux = log(1000),
                     param = Theta1,
                     lambda = c(0, 0, 1),
                     delta = -1)

## now let set the real value of the smallest and the largest design point! why?
equivalence_multiple (x = c(log(.001), -4.6150000, -4.6000000, log(1000)),
                     w =   c(0.499998, 0.2230491, 0.2305728, 0.04637965),
                     lx = log(.001), ux = log(1000),
                     param = Theta1,
                     lambda = c(0, 0, 1),
                     delta = -1)
}
}
}
\seealso{
\code{\link{equivalence}} and \code{\link{equivalence_on_average}}.
}

