% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-UserMinimaxFunctions.R
\name{sensrobust}
\alias{sensrobust}
\title{Verifying Optimality of Robust Designs}
\usage{
sensrobust(formula, predvars, parvars, family = gaussian(), x, w, lx, ux,
  prob, parset, fimfunc = NULL, sens.minimax.control = list(),
  calculate_criterion = TRUE, plot_3d = c("lattice", "rgl"),
  plot_sens = TRUE, npar = dim(parset)[2], silent = FALSE)
}
\arguments{
\item{formula}{A nonlinear model \code{\link[stats]{formula}}.
A symbolic description of the model consists of predictors and the unknown model parameters.
Will be coerced to a \code{\link[stats]{formula}} if necessary.}

\item{predvars}{A vector of characters. Denotes the predictors in the \code{\link[stats]{formula}}.}

\item{parvars}{A vector of characters. Denotes the unknown parameters in the \code{\link[stats]{formula}}.}

\item{family}{A description of the response distribution and link function to be used in the model.
This can be a family function, a call to a family function or a character string naming the family.
 Every family function has a link argument allowing to specify the link function to be applied on the response variable.
  If not specified, default links are used. For details see \code{\link[stats]{family}}.
   By default, a linear gaussian model \code{gaussian()} is applied.}

\item{x}{Vector of design (support) points. See 'Details' of \code{\link{sensminimax}}.}

\item{w}{Vector of corresponding design weights for \code{x}.}

\item{lx}{Vector of lower bounds for the predictors. Should be in the same order as \code{predvars}.}

\item{ux}{Vector of upper bounds for the predictors. Should be in the same order as \code{predvars}.}

\item{prob}{A vector of the probability measure \eqn{\pi} associated with each row of \code{parset}.}

\item{parset}{A matrix to provide the set of initial estimates for the model parameters, i.e. support of \eqn{\pi}.
 Every row is one vector of initial estimates for the model parameters
(\code{nrow(parset) == length(prob)}). See 'Details'.}

\item{fimfunc}{A function. Returns the FIM as a \code{matrix}. Required when \code{formula} is missing. See 'Details' of \code{\link{minimax}}.}

\item{sens.minimax.control}{Control parameters to verify the general equivalence theorem. For details, see the function \code{\link{sens.minimax.control}}.}

\item{calculate_criterion}{Evaluate the D-criterion? See 'Details' of \code{\link{sensminimax}}.}

\item{plot_3d}{Which package should be used to plot the sensitivity (derivative) function for models with two predictors.
Either \code{"rgl"} or \code{"lattice"} (default).}

\item{plot_sens}{Plot the sensitivity (derivative) function? Defaults to \code{TRUE}.}

\item{npar}{Number of model parameters.  Used when \code{fimfunc} is given instead of \code{formula} to specify the number of model parameters.
If not given, the sensitivity plot may be shifted below the y-axis. When \code{NULL}, it will be set here to \code{length(inipars)}.}

\item{silent}{Do not print anything? Defaults to \code{FALSE}.}
}
\value{
an object of class \code{sensminimax} that is a list contains:
 \describe{
 \item{\code{type}}{Argument \code{type} that is required for print methods.}
 \item{\code{optima}}{A  \code{matrix} that stores all the local optima over the parameter space given the best design of the iteration. The cost  (criterion) values are stored in a column named \code{Criterion_Value}.
 The last column (\code{Answering_Set}) shows if the optimum, based on a merging tolerance \code{merge_tol}, belongs to the answering set (1) or not (0).
   Only applicable for minimax or standardized maximin designs.}
 \item{\code{mu}}{Probability measure on the answering set. Corresponds to the rows of \code{optima} when the associated row in column \code{Answering_Set} is equal to 1.
   Only applicable for minimax or standardized maximin designs.}
 \item{\code{max_deriv}}{Global maximum of the sensitivity (derivative) function (\eqn{\epsilon} in 'Details').}
 \item{\code{ELB}}{D-efficiency lower bound. Can not be larger than 1. See 'Note' in \code{\link{sensminimax}} or 'Details' in \code{\link{sens.minimax.control}}.}
 \item{\code{merge_tol}}{Merging tolerance to create the answering set from the set of all local optima. See 'Details' in \code{\link{sens.minimax.control}}.
  Only applicable for minimax or standardized maximin designs.}
 \item{\code{crtval}}{Criterion value. Compare with column \code{Crtiterion_Value} in \code{optima} for minimax and standardized maximin designs.}
 \item{\code{time}}{Required CPU time (rough approximation).}
 }
}
\description{
It plots the sensitivity (derivative) function of the robust criterion
at a given approximate (continuous) design and also
 calculates its efficiency lower bound (ELB) with respect
to this optimality criterion. The user can confirm or reject
 the optimality of a design by looking at the sensitivity plot.
 ELB shows the proximity of a design to the true optimal design without knowing the latter.
}
\details{
Let \eqn{\Theta}  be the set initial estimates for the model parameters and \eqn{\pi} be a probability measure having support in  \eqn{\Theta}.
A design \eqn{\xi^*}{\xi*} is robust with respect to  \eqn{\pi}
if the following inequality holds for all \eqn{\boldsymbol{x} \in \chi}{x belong to \chi}:
 \deqn{c(\boldsymbol{x}, \pi, \xi^*) = \int_{\pi} tr M^{-1}(\xi^*, \theta)I(\boldsymbol{x}, \theta)\pi(\theta) d(\theta)-p \leq 0,}{
         c(x, \pi, \xi*)  = integration over \pi with integrand tr M^-1(\xi*, \theta)I(x, \theta)\pi(\theta) d(\theta)-p <= 0}
          with equality at all support points of \eqn{\xi^*}{\xi*}.
           Here, \eqn{p} is the number of model parameters.

 ELB is a measure of  proximity of a design to the optimal design without knowing the latter.
Given a design, let \eqn{\epsilon} be the global maximum
 of the sensitivity (derivative) function over \eqn{x \in \chi}{x belong to \chi}.
ELB is given by \deqn{ELB = p/(p + \epsilon),}
where \eqn{p} is the number of model parameters. Obviously,
calculating ELB requires finding \eqn{\epsilon} and
another optimization problem to be solved.
The tuning parameters of this optimization can be regulated via the argument  \code{\link{sens.minimax.control}}.
}
\note{
Theoretically, ELB can not be larger than 1. But if so, it may have one of the following reasons:
\itemize{
\item \code{max_deriv} is not a GLOBAL maximum.  Please increase  the value of the parameter \code{maxeval} in \code{\link{sens.minimax.control}} to find the global maximum.
\item The sensitivity function is shifted below the y-axis because
the number of model parameters has not been specified correctly (less value given).
Please specify the correct number of model parameters via argument \code{npar}.
}
}
\examples{
# Verifying a robust design for the two-parameter logistic model
sensrobust(formula = ~1/(1 + exp(-b *(x - a))),
           predvars = c("x"),
           parvars = c("a", "b"),
           family = binomial(),
           prob = rep(1/4, 4),
           parset = matrix(c(0.5, 1.5, 0.5, 1.5, 4.0, 4.0, 5.0, 5.0), 4, 2),
           x = c(0.260, 1, 1.739), w = c(0.275, 0.449, 0.275),
           lx = -5, ux = 5)


}
\seealso{
\code{\link{bayes}} \code{\link{sensbayes}} \code{\link{robust}}
}
