% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{get_predictions}
\alias{get_predictions}
\title{Produce Predictions on an Unseen Dataset}
\usage{
get_predictions(pred_model, new_data, s = NULL, max_panel_length = NULL)
}
\arguments{
\item{pred_model}{(list)
A predictive model as fitted by pred_first_fit(), pred_refit_panel() or
pred_refit_range().}

\item{new_data}{(list)
A new dataset, containing a matrix of observations and a list of sample IDs.
Likely comes from the 'train', 'val' or 'test' argument of a call to
get_mutation_tables().}

\item{s}{(numeric)
If producing predictions for a single panel, s chooses which panel
(column in a pred_fit object) to produce predictions for.}

\item{max_panel_length}{(numeric)
If producing predictions for a single panel, maximum panel length to
specify that panel.}
}
\value{
A list with two elements:
\itemize{
\item predictions, a matrix containing a row for each sample and a column for each
panel.
\item panel_lengths, a vector containing the length of each panel.
}
}
\description{
A function taking a predictive model(s) and new observations, and applying the predictive model to them to return predicted biomarker values.
}
\examples{
example_predictions <- get_predictions(example_refit_range, new_data =
example_tables$val)
}
