% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_data_filter_item.R
\name{shiny_data_filter_item}
\alias{shiny_data_filter_item}
\title{The server function for the filter item module of a data filter module panel}
\usage{
shiny_data_filter_item(
  input,
  output,
  session,
  data,
  column_name = NULL,
  verbose = FALSE
)
}
\arguments{
\item{input}{requisite shiny module field specifying incoming ui input
reactiveValues}

\item{output}{requisite shiny module field capturing output for the shiny
data filter ui}

\item{session}{requisite shiny module field containing the active shiny
session}

\item{data}{a \code{reactive expression} returning a \code{data.frame} to use
as the input to the filter item module}

\item{column_name}{a value indicating the name of the column to be filtered}

\item{verbose}{a \code{logical} value indicating whether or not to print log
statements out to the console}
}
\value{
a \code{\link[shiny]{reactiveValues}} list of three reactive elements;
  (1) a reactive data frame, (2) the code to filter a vector with the name of
  the specified data column, and (3) a flag indicating when to remove this
  filter.
}
\description{
The server function for the filter item module of a data filter module panel
}
\keyword{internal}
