% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_vector_filter_factor_many.R
\name{shiny_vector_filter_factor_many}
\alias{shiny_vector_filter_factor_many}
\title{A vector filter for factors with only a few choices}
\usage{
shiny_vector_filter_factor_many(
  input,
  output,
  session,
  x = shiny::reactive(factor()),
  filter_na = shiny::reactive(FALSE),
  filter_fn = NULL,
  verbose = FALSE,
  erase_filters = shiny::reactive(0)
)
}
\arguments{
\item{input}{requisite shiny module field specifying incoming ui input
reactiveValues}

\item{output}{requisite shiny module field capturing output for the shiny
data filter ui}

\item{session}{requisite shiny module field containing the active shiny
session}

\item{x}{a reactive expression resolving to the vector to filter}

\item{filter_na}{a logical value indicating whether to filter \code{NA}
values from the \code{x} vector}

\item{filter_fn}{A function to modify, specified in one of the following ways:
* A named function, e.g. `mean`.
* An anonymous function, e.g. `\(x) x + 1` or `function(x) x + 1`.
* A formula, e.g. `~ .x + 1`.}

\item{verbose}{a \code{logical} value indicating whether or not to print log
statements out to the console}
}
\value{
a \code{\link[shiny]{reactiveValues}} list containing a logical
  vector called "mask" which can be used to filter the provided vector and an
  element "code" which is the expression used to generate the mask.
}
\description{
A vector filter for factors with only a few choices
}
\keyword{internal}
