% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi.typed.bootstrap}
\alias{get.pi.typed.bootstrap}
\title{runs bootstrapping on \code{get.pi.typed}}
\usage{
get.pi.typed.bootstrap(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), boot.iter, data.frame = TRUE)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{data.frame}{logical indicating whether to return results as a data frame (default = TRUE)}
}
\value{
pi values for all the distances we looked at
}
\description{
Bootstraps typed pi values. Makes sure distances between a sample and
another draw of itself are left out
}
\examples{
\donttest{

data(DengueSimR02)

r.max<-seq(20,1000,20)
r.min<-seq(0,980,20)

#Lets see if there's a difference in spatial dependence by time case occurs
type<-2-(DengueSimR02[,"time"]<120)
tmp<-cbind(DengueSimR02,type=type)

typed.pi.bs<-get.pi.typed.bootstrap(tmp,typeA=1,typeB=2,r=r.max,r.low=r.min,boot.iter=100)

}
}
\seealso{
Other get.pi: \code{\link{get.pi.bootstrap}},
  \code{\link{get.pi.ci}}, \code{\link{get.pi.permute}},
  \code{\link{get.pi.typed.permute}},
  \code{\link{get.pi.typed}}, \code{\link{get.pi}}
}
\concept{get.pi}
