% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.pi.ci}
\alias{get.pi.ci}
\title{Calculate bootstrapped confidence intervals for \code{get.pi} values.}
\usage{
get.pi.ci(posmat, fun, r = 1, r.low = rep(0, length(r)), boot.iter = 1000,
  ci.low = 0.025, ci.high = 0.975)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to decide relationships}

\item{r}{the series of spatial distances wer are interested in}

\item{r.low}{the low end of each range. 0 by default}

\item{boot.iter}{the number of bootstrap iterations}

\item{ci.low}{the low end of the ci...0.025 by default}

\item{ci.high}{the high end of the ci...0.975 by default}
}
\value{
a matrix with a row for the high and low values and
    a column per distance
}
\description{
Wrapper to \code{get.pi.bootstrap} that takes care of calculating the
confidence intervals based on the bootstrapped values..
}
\examples{
\dontrun{
 R/examples/get_pi_ci.R
 }

}
\seealso{
Other get.pi: \code{\link{get.pi.bootstrap}},
  \code{\link{get.pi.permute}},
  \code{\link{get.pi.typed.bootstrap}},
  \code{\link{get.pi.typed.permute}},
  \code{\link{get.pi.typed}}, \code{\link{get.pi}}
}
\author{
Justin Lessler
}
