% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildBatch.R
\name{buildBatch}
\alias{buildBatch}
\title{Batch Builder}
\usage{
buildBatch(
  files,
  compensation,
  analysis,
  default_batch_dir,
  config_file,
  name = "Batch1",
  use_acquisition = FALSE,
  suffix = "",
  allow_channels_dissimilarity = FALSE,
  overwrite = TRUE,
  segment_rif = "None",
  options
)
}
\arguments{
\item{files}{path of files to batch.}

\item{compensation}{path to compensation file.}

\item{analysis}{path to analysis file.}

\item{default_batch_dir}{directory where batches are stored.\cr
It can be found in IDEAS(R) software, under Options -> Application Defaults -> Directories -> Default Batch Report Files Directory.\cr
If missing, the default, it will be deduced from IDEAS(R) config file, However, if it can't be deduced then tempdir(check = TRUE) from \pkg{base} will be used.\cr
This argument takes precedence over 'config_file' and filling 'default_batch_dir' prevents the use of 'config_file' argument.}

\item{config_file}{path to IDEAS(R) config file.\cr
It may depends on IDEAS(R) software installation but one may use "C:/Users/\%USER\%/AppData/Roaming/Amnis Corporation/userconfig.xml".}

\item{name}{name of batch. Default is "Batch1".}

\item{use_acquisition}{whether to use acquisition as analysis template. Default is FALSE.}

\item{suffix}{suffix to add to files when batched. Default is "".}

\item{allow_channels_dissimilarity}{whether to allow building batch when all files were not acquired with same channels. Default is FALSE.}

\item{overwrite}{whether to overwrite files or not. Default is TRUE.}

\item{segment_rif}{size of file segmentation. Default is "None", for no segmentation.\cr
Allowed are "None", "100", "1K", "5K", "10K", "50K", "100K".}

\item{options}{A list of arguments to be passed.\cr
If missing, the default, options will be set to:\cr
-"Brightfield compensation"=TRUE,\cr
-"EDF deconvolution"=TRUE,\cr
-"Camera background"=TRUE,\cr
-"Spatial alignment"=TRUE.\cr
Allowed are TRUE or FALSE for all, excepted for 'Spatial aligment' which can also be path to .rif file.}
}
\value{
a list containing batch information:\cr
-xml, the xml object to be written,\cr
-batch_dir, the directory where xml file is desired to be saved according to 'default_batch_dir' and 'config_file'.
}
\description{
Prepares XML node for \code{\link{ExportToBATCH}}.
}
