% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILS.R
\docType{data}
\name{TG}
\alias{TG}
\title{Thermogravimetry curves}
\format{A 15 x 1000 x 7 dimension array ,  where each matrix consists of the 15 TG curves obtained testing 15 different oxalate samples,
and evaluated in 1000 different values of temperature. These 15 curves were obtained for each of the overall 7 laboratories that have performed the esperiments.}
\description{
One hundred and five Calcium oxalate samples were tested by thermogravimetric (TG) analysis,
obtaining 105 TG curves that shows the mass loss of oxalate depending on time when samples are heated at a constant temperature rate.
Dataset is composed by fifteen TG curves of 1000 observations each of overall 7 different laboratories.
Laboratory 1 uses a simultaneous thermal analyzer (STA) with an old calibration program, Laboratory 2 to Laboratory 4
use a SDT simultaneous analyzer, Laboratory 6 utilizes a SDT simultaneous analyzer with an old calibration, and Laboratory 7
 uses a SDT simultaneous analyzer with a biased calibration (2 degrees Celsius shifted from the zinc melting point).
}
\examples{
library(ILS)
data(TG)
summary(TG)

}
\references{
\describe{
  \item{}{Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014),
  "Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.}
}
}
