% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILSAmerge.R
\name{ILSAmerge}
\alias{ILSAmerge}
\title{Merge ILSA data}
\usage{
ILSAmerge(
  inputdir,
  outputdir,
  population = NULL,
  filetype = c("rds", "zsav", "sav"),
  MBlimit = NULL,
  MBlistlimit = 200,
  SPSSlimit = 50,
  quiet = FALSE
)
}
\arguments{
\item{inputdir}{a string indicating the path were ILSA 'SPSS' files are stored.}

\item{outputdir}{the directory where the merged data will be saved.}

\item{population}{a character vector indicating which files should be merged.
If \code{NULL} (the default), all files will be merged. For more information
on available populations, run \code{ILSAfile.info()} first.}

\item{filetype}{a string indicating the type of file to be saved, it can
be \code{"rds"}, \code{"zsav"}, or \code{"sav"}.}

\item{MBlimit}{a numerical value indicating the allowed limit of the combined
storage of the files of one type (see \code{ILSAfile.info()}).
For type files that go over the limit, files will not be merged in R,
but an 'SPSS' syntax will be produced via \code{spss.syntax()}.
If set to \code{NULL}, no limit will be used and all files will be merged
within R. If speed is a problem, we recommend
that this number should not be over \code{200} and merge the rest in 'SPSS'.}

\item{MBlistlimit}{a numerical value indicating the allowed limit of the
combined storage of the files of one type for merging through a list.
Values over the limit will be merged through a matrix, which will be slower
but uses less memory. Default is \code{200}.}

\item{SPSSlimit}{a numerical value indicating the limit of files per command
of 'SPSS', typically \code{50}.}

\item{quiet}{a logical value indicating if status of progress should be
shown. Default is \code{FALSE}.}
}
\value{
Saves merged ILSA data or \code{.sps} syntax for merging ILSA data.
}
\description{
Merges 'SPSS' data from different International Large-Scale Assessments (ILSA).
This function has been tested to behave correctly for: 'TIMSS', 'TIMSS Advanced', 
'PIRLS', 'ICCS', 'ICILS', 'CIVED', 'REDS', 'RLII', and 'SITES' (2006).
}
\examples{
# For example, after downloading 'RLII' 1991 G4 data:

# Downloading 'RLII' 1991 and unzipping files
ILSAdownload(study = "RLII", year = 1991, outputdir = tempdir(), unzip = TRUE, agreeLicense = TRUE)

# Path were raw 'SPSS' files are
input <- file.path(tempdir(),"RLII1991_IDB_SPSS/Data")

# Path were merged files will be saved
output <- file.path(tempdir(),"RLII1991_IDB_SPSS")

# Merging 'RLII' 1991, as .rds file
ILSAmerge(inputdir = input, outputdir = output, filetype = "rds", quiet = FALSE)

}
