% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_count.R
\name{motif_count}
\alias{motif_count}
\title{Calculating the number of 44 motifs}
\usage{
motif_count(network.or.subnet_mat1, subnet_mat2 = NULL)
}
\arguments{
\item{network.or.subnet_mat1}{Either a multilayer(tripartite) network of 'igraph' class which contains interlayer links and without intralayer links, or a numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and first groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.
Each row and column of matrix represents single species in the second and third groups of the tripartite network respectively.
Elements of matrix are non-zero numbers if the two groups of species are connected, and 0 otherwise. If \code{network.or.subnet_mat1} is "igraph", \code{subnet_mat2} defaults to NULL.}
}
\value{
If \code{subnet_motif} = FALSE, return a numeric vector with the number of 44 motifs: M111, M112, M113, M211, M212, M213, M311, M312, M121_1, M122_1, M122_2, M122_3, M123_1, M123_2, M123_3, M123_4, M123_5, M221_1, M221_2, M221_3, M222_1, M222_2, M222_3, M222_4, M222_5, M222_6, M222_7, M222_8, M321_1, M321_2, M321_3, M321_4, M321_5, M131, M132-1, M132-2, M132-3, M132-4, M132-5, M231-1, M231-2, M231-3, M231-4, M231-5.
}
\description{
Calculating the number of 44 motifs from a tripartite interaction network.
}
\details{
\strong{network.or.subnet_mat1} and \strong{subnet_mat2}

There are two types of \code{network.or.subnet_mat1} that can be processed:
\itemize{
\item{(1). Input in a network of type "igraph" alone.}
\item{(2). Must be entered as data frame or matrix with \code{subnet_mat2}.}
}

If the type of inputting is data frame or matrix, please make sure the row of \code{network.or.subnet_mat1} and \code{subnet_mat2} correspond with the second group of species that both belong to two subnetworks and interact with other groups of species.
\itemize{
\item{Try to make the rows of both matrices have the same attributes. Or we default:}

\item{When the two matrices can have different numbers of rows:}
\itemize{
\item{(1). If both matrices have row names, then the function counts all row names to produce two new matrices with the same row names.}
\item{(2). If at most one matrix has row names, the function assigns new row names to both matrices on a row-to-row basis (any extra row names are assigned a new value) and then counts all row names to produce two new matrices with the same row names.}
}

\item{When the two matrices can have the same numbers of rows:}
\itemize{
\item{No matter how the row names of the two matrices are arranged, as long as the row names are exactly the same; But we don't handle matrices with empty row names (the function will give an error).}
}

\item{The two matrices can have different numbers of rows, but read our default handling carefully to make sure the calculation is accurate when using this function!!!}
}
About a network of type "igraph", It can be obtained from the connection matrices of subnetworks by the function \code{igraph_from_matrices}.
}
\examples{

set.seed(12)
d <- build_net(11,22,21,0.2)
m <- motif_count(d)
m

set.seed(12)
d <- build_net(11,22,21,0.2,asmatrices=TRUE)

MAT<-d
motif_count(MAT[[3]],MAT[[4]])

md1<-matrix(sample(c(0,1),120,replace=TRUE),8,15)
md2<-matrix(sample(c(0,1),120,replace=TRUE),10,12)
motif_count(md1,md2)

R<-rownames(MAT[[4]])[12]
MR<-MAT[[4]][12,]
MAT[[4]]<-MAT[[4]][-12,]
MAT[[4]]<-rbind(MAT[[4]],MR)
rownames(MAT[[4]])[22]<-R

motif_count(MAT[[3]],MAT[[4]])


}
\references{
Pilosof, S., Porter, M. A., Pascual, M., & Kéfi, S. (2017). The multilayer nature of ecological networks. Nature Ecology & Evolution, 1(4), 0101.

Simmons, B. I., Sweering, M. J., Schillinger, M., Dicks, L. V., Sutherland, W. J., & Di Clemente, R. (2019). bmotif: A package for motif analyses of bipartite networks. Methods in Ecology and Evolution, 10(5), 695-701.
}
