% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingFunctions.R
\name{plot_cols}
\alias{plot_cols}
\title{Plots a matrix of colours}
\usage{
plot_cols(cmat,
          na.col = "#808080FF",
          ptype = c("image", "points"),
          border.col = "#808080FF",
          dlabels = NULL,
          rlabels = FALSE,
          clabels = FALSE,
          pch = 15,
          cex = 3,
          label.cex = 0.6,
          ...)
}
\arguments{
\item{cmat}{A matrix of valid colours, with missing values coded as \code{NA} allowed. Vectors should be supplied as matrices with 1 row or column, as appropriate.}

\item{na.col}{Colour used for missing \code{NA} entries in \code{cmat}.}

\item{ptype}{Switch controlling output as either a heat map \code{"image"} (the default) or as \code{"points"}.}

\item{border.col}{Colour of border drawn around the plot.}

\item{dlabels, rlabels, clabels}{Vector of labels for the diagonals, rows, and columns, respectively.}

\item{pch}{Point type used when \code{ptype="points"}.}

\item{cex}{Point cex used when \code{ptype="points"}.}

\item{label.cex}{Govens cex parameter used for labels.}

\item{...}{Further graphical parameters.}
}
\value{
Either an \code{"image"} or \code{"points"} type plot of the supplied colours.
}
\description{
Plots a matrix of colours as a heat map type image or as points. Intended for joint use with \code{mat2cols}.
}
\examples{
# Generate a colour matrix using mat2cols()
mat      <- matrix(rnorm(100), nrow=10, ncol=10)
mat[2,3] <- NA
cols     <- heat.colors(12)[12:1]
(matcol  <- mat2cols(mat, cols=cols))

# Use plot_cols() to visualise the colours matrix
par(mar=c(5.1, 4.1, 4.1, 4.1))
plot_cols(matcol)

# Add a legend using heat_legend()
heat_legend(mat, cols=cols); box(lwd=2)
}
\seealso{
\code{\link{mat2cols}}, \code{\link[graphics]{image}}, \code{\link{heat_legend}}, \code{\link{is.cols}}
}
\keyword{plotting}
