# empirical p.d.f. of the target value
render_FV_PDF <- reactive({
  req(input$FCEPDF.Bar.Runtime, length(DATA()) > 0)
  withProgress({
  runtime <- input$FCEPDF.Bar.Runtime %>% as.numeric
  data <- subset(DATA(), algId %in% input$FCEPDF.Bar.Algs)
  Plot.FV.PDF(data, runtime, show.sample = input$FCEPDF.Bar.Samples,
              scale.ylog = input$FCEPDF.Bar.Logy )
  },
  message = "Creating plot")
})

output$FCEPDF.Bar.Download <- downloadHandler(
  filename = function() {
    eval(FIG_NAME_FV_PDF)
  },
  content = function(file) {
    save_plotly(render_FV_PDF(), file)
  },
  contentType = paste0('image/', input$FCEPDF.Bar.Format)
)

output$FCE_PDF <- renderPlotly({
  render_FV_PDF()
})

# historgram of the target values -----------
render_FV_HIST <- reactive({
  req(input$FCEPDF.Hist.Runtime != "", length(DATA()) > 0)   # require non-empty input
  withProgress({
  runtime <- input$FCEPDF.Hist.Runtime %>% as.numeric
  data <- subset(DATA(), algId %in% input$FCEPDF.Hist.Algs)
  Plot.FV.Histogram(data, runtime, plot_mode = input$FCEPDF.Hist.Mode, use.equal.bins = input$FCEPDF.Hist.Equal)
  },
  message = "Creating plot")
})

output$FCEPDF.Hist.Download <- downloadHandler(
  filename = function() {
    eval(FIG_NAME_FV_HIST)
  },
  content = function(file) {
    save_plotly(render_FV_HIST(), file)
  },
  contentType = paste0('image/', input$FCEPDF.Hist.Format)
)

output$FCE_HIST <- renderPlotly({
  render_FV_HIST()
})
