% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Algorithms.R
\name{IOH_two_rate_GA}
\alias{IOH_two_rate_GA}
\alias{two_rate_GA}
\title{IOHexperimenter-based wrapper}
\usage{
IOH_two_rate_GA(IOHproblem, lambda_ = 1, budget = NULL)

two_rate_GA(dimension, obj_func, target_hit = function() {     FALSE },
  lambda_ = 2, budget = NULL, set_parameters = NULL)
}
\arguments{
\item{IOHproblem}{An IOHproblem object}

\item{lambda_}{The size of the offspring}

\item{budget}{How many times the objective function can be evaluated}

\item{dimension}{Dimension of search space}

\item{obj_func}{The evaluation function}

\item{target_hit}{Optional, function which enables early stopping if a target value is reached}

\item{set_parameters}{Function to call to store the value of the registered parameters}
}
\value{
A list containing the location (xopt) and value (fopt) of the optimal value found
}
\description{
For easier use with the IOHexperimenter

A genetic algorithm that controls the mutation rate (strength) using the so-called 
2-rate self-adaptation mechanism: the mutation rate is based on a parameter r. For
each generation, half offspring are generated by mutation rate 2r/dim, and half by 
r/2dim. r that the best offspring has been created with will be inherited by 
probability 3/4, the other by 1/4.
}
\examples{
\donttest{
bechmark_algorithm(IOH_two_rate_GA)
}
}
