% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WITSclean_function.R
\name{WITSclean}
\alias{WITSclean}
\title{WITS data clean}
\usage{
WITSclean(CSVfile, YEAR, threshold, cutoff)
}
\arguments{
\item{CSVfile}{WITS csv file}

\item{YEAR}{Year}

\item{threshold}{Apply a threshold - TRUE, Extract the backbone - FALSE}

\item{cutoff}{Threshold - cutoff level, Backbone - significance level}
}
\value{
International Trade Network - igraph object
}
\description{
This function takes (import) trade data downloaded from WITS, cleans it and transforms it into a network.
Adding a number of country level attributes to nodes in the network, including: regional partition, GDP, GDP per capita, GDP growth and FDI.
}
\examples{
\donttest{
##Create an igraph object from international
##trade data downloaded from WITS

##Applies a threhold
##only retains ties that are at least
## 0.01\% of total trade

ITN<-WITSclean("WITS_CSV_FILE_NAME.csv",2015,TRUE,0.01)

}
}
