% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{getMap}
\alias{getMap}
\title{Map one observation or prediction}
\usage{
getMap(ice, plotting = FALSE, reg = regionInfo$regions,
  lines = regionInfo$lines, out = regionInfo$out, main = "",
  myLand = land, nSpace = 7)
}
\arguments{
\item{ice}{\code{SpatialPolygon} object corresponding to the region of ice}

\item{plotting}{boolean indicating if map should be plotted}

\item{reg}{region information list (defaults to regionInfo$regions)}

\item{lines}{lines (defaults to regionInfo$lines)}

\item{out}{back stop (defaults to regionInfo$out)}

\item{main}{character vector giving the title for the plotting map (defaults to no title)}

\item{myLand}{\code{SpatialPolygon} corresponding to the land}

\item{nSpace}{Spacing between points and lines that should be plotted (defaults to every seventh point and arrow)}
}
\value{
List of the length of the number of regions. Each item in the list is a matrix. Each row of each matrix corresponds to a point in the region's fixed line. The seven columns give the fixed point's x-coordinate,
the fixed point's y-coordinate, the mapped point's x-coordinate, the mapped point's y-coordinate, the length of the mapping vectors in the
x-direction, the length of the vectors in the y-direction, and the angles of the mapping vectors.
}
\description{
Find the mapping vectors for one observation or prediction.
}
\details{
Often \code{reg}, \code{lines}, and \code{out} are taken from a region information list.
A region information list is a list of six objects: \code{regions}, \code{lines}, \code{out}, \code{centRegion}, \code{centLines}, and
\code{centFrom}. The first three objects are ordered lists giving information about each of the regions that will be mapped outside the
Central Arctic region. The variable \code{regions} gives \code{SpatialPolygons} objects for the corresponding regions and the variable \code{lines}
 gives the \code{SpatialLines} objects for the corresponding fixed lines. The variable \code{out} gives \code{SpatialPolygons} objects that are outside the corresponding regions,
 but that border the fixed lines. These are used when building new polygons to determine if points are being mapped outside the region of interest.
 The variable \code{centRegions} is the \code{SpatialPolygons} object corresponding to the central Arctic region, \code{centLines} is the \code{SpatialLines} object for the fixed line,
 and \code{centFrom} is an n x 2 matrix with each row repeatedly giving the coordinates of the center point from which mapping vectors will emanate.
 The package contains \code{regionInfo} in the \code{regionInfo.rda} file, which can be used unless you want to define your own regions.
}
\examples{
\dontrun{
obs <- getRegion(dat = obsFeb19811982[1,,], datType = "bootstrap", level = 15)
obsMap <- getMap(ice = obs, plotting = TRUE,
                 main = "Observed Mapping \\n February 1985")
}
}
