% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rmHoles}
\alias{rmHoles}
\title{Remove holes in a polygon}
\usage{
rmHoles(myPoly, polyName = "notSpecified")
}
\arguments{
\item{myPoly}{\code{SpatialPolygons} object}

\item{polyName}{character string to name polygon (defaults to "notSpecified")}
}
\value{
\code{SpatialPolygons} object with holes removed
}
\description{
Remove holes from a \code{SpatialPolygons} object.  Note that this function differs from the function \code{findHoles} in that
it only removes holes contained within the polygon itself, not gaps between the polygon and region boundaries
}
\examples{
withHoles <- bgWater[2]
plot(withHoles, col = "blue", main = "Polygon with Holes")
noHoles <- rmHoles(withHoles)
plot(noHoles, col = "blue", main = "Holes removed")
}
