% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biasCorrect.R
\name{contour_shift}
\alias{contour_shift}
\title{Apply contour-shifting to bias correct}
\usage{
contour_shift(maps, predicted, bc_year, pred_start_year, reg_info, level,
  dat_type_pred, my_land_mat = land_mat, my_land = land,
  n_train_years = NULL)
}
\arguments{
\item{maps}{object obtained from the \code{create_mapping} function
(see details)}

\item{predicted}{array of predicted values of dimension year x month x
longitude x latitude}

\item{bc_year}{year to be bias-corrected}

\item{pred_start_year}{year prediction array starts in}

\item{reg_info}{a \code{reg_info} list (see documentation for \code{reg_info})}

\item{level}{concentration level for which to build contour}

\item{dat_type_pred}{string indicating the format of the prediction: either
"gfdl" or "simple" (see details)}

\item{my_land_mat}{binary matrix specifying land locations}

\item{my_land}{\code{SpatialPolygons} corresponding to the land}

\item{n_train_years}{number of years prior to the current year used in fitting
the bias correction}
}
\value{
\code{SpatialPolygons} object of the adjusted region
}
\description{
Apply contour-shifting to bias correct a predicted contour
using existing mappings.
}
\details{
The \code{map} parameter is a list of length four that has the form
         of a list obtained from running the \code{create_mapping} function.
         The values \code{start_year} and \code{endYear} give the
         first and last year that were mapped. The variables
         \code{obs_list} and \code{pred_list} are lists of arrays with one
         3-dimensional array for each region. The first dimension of each array
         coresponds to the year, the second dimension corresponds to the lines
         on which the region is being mapped, and the third dimension
         corresponds to the variables of interest. The first and second
         dimension are indexed sequentially. The variables for the third dimension
         are for the fixed points' x-coordinates, the fixed points' y-coordinates,
         the mapped points' x-coordinates, the mapped points' y-coordinates,
         the length of the mapping vectorsin the x-direction,
         the length of the vectors in the y-direction, and the angles of the
         mapping vectors.
         The predicted data array, \code{predicted}, should be a single array
         of dimension: years x longitude (304) x latitude (448). If
         \code{dat_type_pred = ``simple"}, the values in the array should
         indicate whether each grid box is categorized to contain ice
         (1: ice-covered, 0: no ice, NA: land). If
         \code{dat_type_pred =``gfdl"} the
         values in the \code{predicted} array correspond to the raw ice
         concentrations values predicted (including indicators for missing
         data, land etc.) formatted as in the CM2.5 Forecast-oriented
         Low-Ocean Resolution (FLOR) model produced by the National Oceanic
         and Atmospheric Administration’s Geophysical Fluid Dynamics
         Laboratory and converted to a Polar Stereographic grid
         (Vecchi et al. 2014; Msadek et al. 2014). Weights for converting to
         a polar stereograhic grid were obtained from the spherical
         coordinate remapping and interpolation package (SCRIP) (Jones 1997).
}
\examples{
\dontrun{
adj <- contour_shift(maps = discrep, predicted = emFeb2012, bc_year = 2012,
                     pred_start_year = 1980, reg_info, level = 15,
                     dat_type_pred = "gfdl")
plot(land, col = "grey", border = FALSE)
plot(adj, add = TRUE, col = "blue")
}
}
\references{
Jones, P.W. "A user’s guide for SCRIP: A spherical coordinate remapping and interpolation package."
Los Alamos National Laboratory, Los Alamos, NM (1997).

Msadek, R., et al.
\href{http://onlinelibrary.wiley.com/doi/10.1002/2014GL060799/full}{"Importance of initial conditions in seasonal predictions of Arctic sea ice extent."}
 Geophysical Research Letters 41.14 (2014): 5208-5215.

Vecchi, Gabriel A., et al.
\href{http://journals.ametsoc.org/doi/abs/10.1175/JCLI-D-14-00158.1}{"On the seasonal forecasting of regional tropical}
cyclone activity." Journal of Climate 27.21 (2014): 7994-8016.
}
