% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCF.R
\name{fit_weights}
\alias{fit_weights}
\title{Compute weighting between two models}
\usage{
fit_weights(mod1, mod2, obs, prop_area, w_ini = 0.5, z_ini = 0.5,
  eps = 0.01)
}
\arguments{
\item{mod1}{array with estimated sea ice probability from model 1. Dimensions
are nuumber of training years x lon x lat.}

\item{mod2}{array with estimated sea ice probability from model 2. Dimensions
are nuumber of training years x lon x lat.}

\item{obs}{array with observations of sea ice presence (1) and absence (0).
Dimensions are nuumber of training years x lon x lat.}

\item{prop_area}{matrix that gives the proportion of area in each grid box.
Should sum to 1. Dimensions are lon x lat.}

\item{w_ini}{initial value of all w, defaults to 0.5.}

\item{z_ini}{initial value of all z, defaults to 0.5.}

\item{eps}{tolerance for EM algorithm to reach convergence, defaults to 0.01.}
}
\value{
value between 0 and 1 giving the weight on the first model
}
\description{
Compute weighting between two models based on accuracy in predicting a
set of observations. Computation is via the Expectation-Maximization algorithm.
}
\examples{
\dontrun{
weight <- fit_weights(mod1 = clim_9_2005_2007, mod2 = ppe_9_2005_2007,
obs = obs_9_2005_2007, prop_area = prop_area)
}
}
