% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indivplot.r
\name{indivplot}
\alias{indivplot}
\title{plot aggregated COD distribution}
\usage{
indivplot(x, type = c("errorbar", "bar")[1], top = 10, causelist = NULL,
  which.plot = NULL, xlab = "Causes", ylab = "COD distribution",
  title = "COD distributions for the top causes", horiz = TRUE,
  angle = 60, fill = "lightblue", err_width = 0.4, err_size = 0.6,
  point_size = 2, border = "black", bw = FALSE, ...)
}
\arguments{
\item{x}{object from \code{get.indiv} function.}

\item{type}{An indicator of the type of chart to plot. "errorbar" for line
plots of only the error bars on single population; "bar" for bar chart with
error bars on single population.}

\item{top}{The number of top causes to plot. If multiple sub-populations are
to be plotted, it will plot the union of the top causes in all
sub-populations.}

\item{causelist}{The list of causes to plot. It could be a numeric vector
indicating the position of the causes in the InterVA cause list (see
\code{\link{causetext}}), or a vector of character string of the cause
names. The argument supports partial matching of the cause names. e.g.,
"HIV/AIDS related death" could be abbreviated into "HIV"; "Other and
unspecified infect dis" could be abbreviated into "Other and unspecified
infect".}

\item{which.plot}{Specification of which group to plot if there are
multiple.}

\item{xlab}{Labels for the causes.}

\item{ylab}{Labels for the CSMF values.}

\item{title}{Title of the plot.}

\item{horiz}{Logical indicator indicating if the bars are plotted
horizontally.}

\item{angle}{Angle of rotation for the texts on x axis when \code{horiz} is
set to FALSE}

\item{fill}{The color to fill the bars when \code{type} is set to "bar".}

\item{err_width}{Size of the error bars.}

\item{err_size}{Thickness of the error bar lines.}

\item{point_size}{Size of the points.}

\item{border}{The color to color the borders of bars when \code{type} is set
to "bar".}

\item{bw}{Logical indicator for setting the theme of the plots to be black
and white.}

\item{\dots}{Not used.}
}
\description{
Produce a bar plot of the aggregated COD distribution as approximate CSMFs for a fitted \code{"insilico"} object.
}
\examples{

\dontrun{
# Toy example with 1000 VA deaths
data(RandomVA1)
fit1<- insilico(RandomVA1, subpop = NULL,  
              Nsim = 1000, burnin = 500, thin = 10 , seed = 1,
              auto.length = FALSE)
summary(fit1, id = "d199")

# update credible interval for individual probabilities to 90\%
indiv.new <- get.indiv(fit1, CI = 0.9)
fit1$indiv.prob.lower <- indiv.new$lower
fit1$indiv.prob.upper <- indiv.new$upper
fit1$indiv.CI <- 0.9
summary(fit1, id = "d199")


# get empirical aggregated COD distribution 
agg.csmf <- get.indiv(data = RandomVA2, fit1, CI = 0.95, 
                      is.aggregate = TRUE, by = NULL)
head(agg.csmf)

# aggregate individual COD distribution by sex and age
# note the model was fitted assuming the same CSMF for all deaths
# this aggregation provides an approximate CSMF for each sub-groups
agg.by.sex.age <- get.indiv(data = RandomVA2, fit1, CI = 0.95, 
                        is.aggregate = TRUE, by = list("sex", "age"))
head(agg.by.sex.age$mean)

# plot of aggregated individual COD distribution
# 0. plot for all data
indivplot(agg.csmf, top = 10)
# 1. plot for specific one group
indivplot(agg.by.sex.age, which.plot = "Men 60-", top = 10)
# 2. comparing multiple groups
indivplot(agg.by.sex.age, which.plot = list("Men 60+", "Men 60-"), 
                          top = 5)
# 3. comparing multiple groups on selected causes
indivplot(agg.by.sex.age, which.plot = list("Men 60-", "Women 60-"), 
                          top = 0, causelist = c(
                            "HIV/AIDS related death", 
                            "Pulmonary tuberculosis", 
                            "Other and unspecified infect dis", 
                            "Other and unspecified NCD"))
} 
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C.
Crampin, Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death
assignment using verbal autopsies, \emph{arXiv preprint arXiv:1411.3042}
\url{http://arxiv.org/abs/1411.3042} (2014)
}
\seealso{
\code{\link{insilico}}, \code{\link{summary.insilico}}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
\keyword{InSilicoVA}
