/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBuffer3DConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer3D
extends PersistentObject
implements BooleanBuffer3DConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBuffer3DConsumer target;
    protected boolean[] xElements;
    protected boolean[] yElements;
    protected boolean[] zElements;
    protected BooleanArrayList xList;
    protected BooleanArrayList yList;
    protected BooleanArrayList zList;
    protected int capacity;
    protected int size;

    public BooleanBuffer3D(BooleanBuffer3DConsumer booleanBuffer3DConsumer, int n) {
        this.target = booleanBuffer3DConsumer;
        this.capacity = n;
        this.xElements = new boolean[n];
        this.yElements = new boolean[n];
        this.zElements = new boolean[n];
        this.xList = new BooleanArrayList(this.xElements);
        this.yList = new BooleanArrayList(this.yElements);
        this.zList = new BooleanArrayList(this.zElements);
        this.size = 0;
    }

    public void add(boolean bl, boolean bl2, boolean bl3) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = bl;
        this.yElements[this.size] = bl2;
        this.zElements[this.size++] = bl3;
    }

    public void addAllOf(BooleanArrayList booleanArrayList, BooleanArrayList booleanArrayList2, BooleanArrayList booleanArrayList3) {
        int n = booleanArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(booleanArrayList, booleanArrayList2, booleanArrayList3);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.zList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList, this.zList);
            this.size = 0;
        }
    }
}

