/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class MathUtil {
    public static double[] norm(double[] x) {
        int i;
        double[] xnorm = new double[x.length];
        double sumx = 0.0;
        for (i = 0; i < x.length; ++i) {
            sumx += x[i];
        }
        if (sumx == 0.0) {
            for (i = 0; i < xnorm.length; ++i) {
                xnorm[i] = 0.0;
            }
        } else {
            for (i = 0; i < xnorm.length; ++i) {
                xnorm[i] = x[i] / sumx;
            }
        }
        return xnorm;
    }

    public static double truncbeta(BetaDistribution beta, Random rand, double min, double max) {
        double value = min;
        double ymin = beta.cumulativeProbability(min);
        double ymax = beta.cumulativeProbability(max);
        if (Math.abs(ymax - ymin) < 1.0E-8) {
            return (max + min) / 2.0;
        }
        value = beta.inverseCumulativeProbability(rand.nextDouble() * (ymax - ymin) + ymin);
        if (value == 0.0) {
            System.out.printf("lower %.6f, upper %.6f, sampled 0\n", ymin, ymax);
        }
        return value;
    }

    public static double array_min(double[] array, ArrayList<Integer> location) {
        double min = Double.MAX_VALUE;
        for (int i : location) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double array_max(double[] array, ArrayList<Integer> location) {
        double max = Double.MIN_VALUE;
        for (int i : location) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static double[] grab2(double[][] matrix, int col) {
        double[] out = new double[matrix.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = matrix[i][col];
        }
        return out;
    }

    public static int[] grab2(int[][] matrix, int col) {
        int[] out = new int[matrix.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = matrix[i][col];
        }
        return out;
    }

    public static double getMean(double[] vec) {
        double mean = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            mean += vec[i];
        }
        return mean /= (double)vec.length + 0.0;
    }

    public static double getPercentile(double[] vec, double p) {
        Percentile perc = new Percentile();
        return perc.evaluate(vec, p * 100.0);
    }
}

