/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DelegateFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix3D;

public class WrapperFloatMatrix3D
extends FloatMatrix3D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix3D content;

    public WrapperFloatMatrix3D(FloatMatrix3D floatMatrix3D) {
        block3: {
            if (floatMatrix3D != null) {
                try {
                    this.setUp(floatMatrix3D.slices(), floatMatrix3D.rows(), floatMatrix3D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = floatMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public void dct3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dct3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dct3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dct2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dct2Slices(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dct2Slices(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dst3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dst3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dst2Slices(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dst2Slices(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht3() {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dht3();
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dht3();
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2Slices() {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).dht2Slices();
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.dht2Slices();
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).fft3();
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.fft3();
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeFComplexMatrix3D getFft3() {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix3D)this.content).getFft3();
            }
            return ((DenseLargeFloatMatrix3D)this.copy()).getFft3();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix3D getIfft3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix3D)this.content).getIfft3(bl);
            }
            return ((DenseLargeFloatMatrix3D)this.copy()).getIfft3(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix3D getFft2Slices() {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix3D)this.content).getFft2Slices();
            }
            return ((DenseLargeFloatMatrix3D)this.copy()).getFft2Slices();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix3D getIfft2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix3D)this.content).getIfft2Slices(bl);
            }
            return ((DenseLargeFloatMatrix3D)this.copy()).getIfft2Slices(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public void idct3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idct3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idct3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idct2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idct2Slices(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idct2Slices(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idst3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idst3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idst2Slices(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idst2Slices(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idht3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idht3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).idht2Slices(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.idht2Slices(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix3D)this.content).ifft3(bl);
            } else {
                DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = (DenseLargeFloatMatrix3D)this.copy();
                denseLargeFloatMatrix3D.ifft3(bl);
                this.assign(denseLargeFloatMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized float getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public FloatMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, float f) {
        this.content.setQuick(n, n2, n3, f);
    }

    public FloatMatrix1D vectorize() {
        DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseFloatMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateFloatMatrix2D(this, 2, n);
    }

    public FloatMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, f);
            }

            public synchronized float get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, float f) {
                this.content.set(n, n2, this.columns - 1 - n3, f);
            }
        };
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateFloatMatrix2D(this, 0, n);
    }

    public FloatMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, f);
            }

            public synchronized float get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, float f) {
                this.content.set(this.slices - 1 - n, n2, n3, f);
            }
        };
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperFloatMatrix3D wrapperFloatMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f) {
                    this.content.setQuick(n2, n, n3, f);
                }

                public synchronized float get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, float f) {
                    this.content.set(n2, n, n3, f);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f) {
                    this.content.setQuick(n2, n3, n, f);
                }

                public synchronized float get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, float f) {
                    this.content.set(n2, n3, n, f);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f) {
                    this.content.setQuick(n3, n2, n, f);
                }

                public synchronized float get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, float f) {
                    this.content.set(n3, n2, n, f);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f) {
                    this.content.setQuick(n3, n, n2, f);
                }

                public synchronized float get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, float f) {
                    this.content.set(n3, n, n2, f);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperFloatMatrix3D.slices = nArray[n];
        wrapperFloatMatrix3D.rows = nArray[n2];
        wrapperFloatMatrix3D.columns = nArray[n3];
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float f) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, f);
            }

            public synchronized float get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, float f) {
                this.content.set(n + n4, n2 + n22, n3 + n32, f);
            }
        };
        wrapperFloatMatrix3D.slices = n4;
        wrapperFloatMatrix3D.rows = n5;
        wrapperFloatMatrix3D.columns = n6;
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateFloatMatrix2D(this, 1, n);
    }

    public FloatMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, f);
            }

            public synchronized float get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, float f) {
                this.content.set(n, this.rows - 1 - n2, n3, f);
            }
        };
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], f);
            }

            public synchronized float get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, float f) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], f);
            }
        };
        wrapperFloatMatrix3D.slices = nArray.length;
        wrapperFloatMatrix3D.rows = nArray2.length;
        wrapperFloatMatrix3D.columns = nArray3.length;
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    public FloatMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFloatMatrix3D wrapperFloatMatrix3D = new WrapperFloatMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float f) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, f);
            }

            public synchronized float get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, float f) {
                this.content.set(n * n4, n2 * n22, n3 * n32, f);
            }
        };
        if (this.slices != 0) {
            wrapperFloatMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperFloatMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperFloatMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperFloatMatrix3D.isNoView = false;
        return wrapperFloatMatrix3D;
    }

    protected FloatMatrix3D getContent() {
        return this.content;
    }

    public FloatMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected FloatMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected FloatMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }
}

