% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L2OptW.R
\name{L2OptW}
\alias{L2OptW}
\title{L2OptW}
\usage{
L2OptW(k, d)
}
\arguments{
\item{k}{The tuning parameter that gives the number of neighbours that will be considered by the weighted Kozachenko--Leonenko estimator.}

\item{d}{The dimension of the data.}
}
\value{
The weight vector that is the solution of the optimisation problem.
}
\description{
Calculates a weight vector to be used for the weighted Kozachenko--Leonenko estimator. The weight vector has minimum \eqn{L_2} norm subject to the linear and sum-to-one constraints of (2) in Berrett, Samworth and Yuan (2017).
}
\examples{
# When d < 4 there are no linear constraints and the returned vector is (0,0,...,0,1).
L2OptW(100,3)    
w=L2OptW(100,4)
plot(w,type="l")
w=L2OptW(100,8);
# For each multiple of 4 that d increases an extra constraint is added.
plot(w,type="l")  
w=L2OptW(100,12)
plot(w, type="l") # This can be seen in the shape of the plot

}
\references{
\insertRef{BSY2017}{IndepTest}
}
